/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.engine;

import dev.hilla.parser.utils.ConfigList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class GeneratorConfiguration {
    private Plugins plugins;

    public Optional<Plugins> getPlugins() {
        return Optional.ofNullable(this.plugins);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratorConfiguration that = (GeneratorConfiguration)o;
        return Objects.equals(this.plugins, that.plugins);
    }

    public int hashCode() {
        return Objects.hash(this.plugins);
    }

    void setPlugins(Plugins plugins) {
        this.plugins = plugins;
    }

    public static class Plugins
    implements ConfigList<Plugin> {
        private final List<Plugin> disable = new ArrayList<Plugin>();
        private final boolean disableAllDefaults;
        private final List<Plugin> use = new ArrayList<Plugin>();

        public Plugins() {
            this.disableAllDefaults = false;
        }

        Plugins(@Nonnull Collection<Plugin> use, @Nonnull Collection<Plugin> disable, boolean disableAllDefaults) {
            this.use.addAll(use);
            this.disable.addAll(disable);
            this.disableAllDefaults = disableAllDefaults;
        }

        public List<Plugin> getDisable() {
            return this.disable;
        }

        public List<Plugin> getUse() {
            return this.use;
        }

        public boolean isDisableAllDefaults() {
            return this.disableAllDefaults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugins plugins = (Plugins)o;
            return this.disableAllDefaults == plugins.disableAllDefaults && Objects.equals(this.disable, plugins.disable) && Objects.equals(this.use, plugins.use);
        }

        public int hashCode() {
            return Objects.hash(this.disable, this.disableAllDefaults, this.use);
        }

        public Collection<Plugin> getDisabledOptions() {
            return this.disable;
        }

        public Collection<Plugin> getUsedOptions() {
            return this.use;
        }

        public boolean shouldAllDefaultsBeDisabled() {
            return this.disableAllDefaults;
        }
    }

    static class PluginsProcessor
    extends ConfigList.Processor<Plugin> {
        private static final List<Plugin> DEFAULTS = List.of(new Plugin("@hilla/generator-typescript-plugin-backbone"), new Plugin("@hilla/generator-typescript-plugin-client"), new Plugin("@hilla/generator-typescript-plugin-barrel"), new Plugin("@hilla/generator-typescript-plugin-model"), new Plugin("@hilla/generator-typescript-plugin-push"), new Plugin("@hilla/generator-typescript-plugin-subtypes"));

        PluginsProcessor() {
            super(DEFAULTS);
        }
    }

    public static class Plugin {
        private String path;

        public Plugin() {
        }

        Plugin(String path) {
            this.path = path;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plugin)) {
                return false;
            }
            return Objects.equals(this.path, ((Plugin)other).path);
        }

        public String getPath() {
            return this.path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

