/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.engine;

import com.vaadin.flow.component.dependency.NpmPackage;
import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.GeneratorConfiguration;
import dev.hilla.engine.GeneratorException;
import dev.hilla.engine.GeneratorShellRunner;
import dev.hilla.engine.commandrunner.CommandNotFoundException;
import dev.hilla.engine.commandrunner.CommandRunnerException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NpmPackage.Container(value={@NpmPackage(value="@hilla/generator-typescript-core", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-utils", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-cli", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-plugin-client", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-plugin-backbone", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-plugin-barrel", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-plugin-model", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-plugin-push", version="2.5.6"), @NpmPackage(value="@hilla/generator-typescript-plugin-subtypes", version="2.5.6")})
public final class GeneratorProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorProcessor.class);
    private static final Path TSGEN_PATH = Paths.get("node_modules", "@hilla", "generator-typescript-cli", "bin", "index.js");
    private final Path baseDir;
    private final String nodeCommand;
    private final Path openAPIFile;
    private final Path outputDirectory;
    private final GeneratorConfiguration.PluginsProcessor pluginsProcessor = new GeneratorConfiguration.PluginsProcessor();

    public GeneratorProcessor(EngineConfiguration conf, String nodeCommand) {
        this.baseDir = conf.getBaseDir();
        this.openAPIFile = conf.getOpenAPIFile();
        this.outputDirectory = conf.getOutputDir();
        this.nodeCommand = nodeCommand;
        this.applyConfiguration(conf.getGenerator());
    }

    public void process() throws GeneratorException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(TSGEN_PATH);
        this.prepareOutputDir(arguments);
        this.preparePlugins(arguments);
        this.prepareVerbose(arguments);
        try {
            GeneratorShellRunner runner = new GeneratorShellRunner(this.baseDir.toFile(), this.nodeCommand, (String[])arguments.stream().map(Objects::toString).toArray(String[]::new));
            runner.run(stdIn -> {
                try {
                    Files.copy(this.openAPIFile, stdIn);
                }
                catch (IOException e) {
                    throw new LambdaException(e);
                }
            });
        }
        catch (LambdaException e) {
            throw new GeneratorException("Node execution failed", e.getCause());
        }
        catch (CommandNotFoundException e) {
            throw new GeneratorException("Node command not found", e);
        }
        catch (CommandRunnerException e) {
            throw new GeneratorException("Node execution failed", e);
        }
    }

    private GeneratorProcessor applyConfiguration(GeneratorConfiguration generatorConfiguration) {
        if (generatorConfiguration == null) {
            return this;
        }
        generatorConfiguration.getPlugins().ifPresent(this::applyPlugins);
        return this;
    }

    private void applyPlugins(@Nonnull GeneratorConfiguration.Plugins plugins) {
        this.pluginsProcessor.setConfig(plugins);
    }

    private void prepareOutputDir(List<Object> arguments) {
        Path result = this.outputDirectory.isAbsolute() ? this.outputDirectory : this.baseDir.resolve(this.outputDirectory);
        arguments.add("-o");
        arguments.add(result);
    }

    private void preparePlugins(List<Object> arguments) {
        this.pluginsProcessor.process().stream().map(GeneratorConfiguration.Plugin::getPath).distinct().forEachOrdered(path -> {
            arguments.add("-p");
            arguments.add(path);
        });
    }

    private void prepareVerbose(List<Object> arguments) {
        if (logger.isDebugEnabled()) {
            arguments.add("-v");
        }
    }

    private static class LambdaException
    extends RuntimeException {
        public LambdaException(Throwable cause) {
            super(cause);
        }
    }
}

