/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.maven;

import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.GeneratorException;
import dev.hilla.engine.GeneratorProcessor;
import dev.hilla.engine.ParserException;
import dev.hilla.engine.ParserProcessor;
import dev.hilla.maven.EngineGenerateMojoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(goal="configure")
public final class EngineGenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="node")
    private String nodeCommand;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws EngineGenerateMojoException {
        try {
            Path baseDir = this.project.getBasedir().toPath();
            Path buildDir = baseDir.resolve(this.project.getBuild().getDirectory());
            EngineConfiguration conf = Objects.requireNonNull(EngineConfiguration.load((File)buildDir.toFile()));
            LinkedHashSet classPath = conf.getClassPath();
            ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
            for (String classPathItem : classPath) {
                urls.add(new File(classPathItem).toURI().toURL());
            }
            URLClassLoader classLoader = new URLClassLoader((URL[])urls.toArray(URL[]::new), ((Object)((Object)this)).getClass().getClassLoader());
            ParserProcessor parserProcessor = new ParserProcessor(conf, (ClassLoader)classLoader);
            GeneratorProcessor generatorProcessor = new GeneratorProcessor(conf, this.nodeCommand);
            parserProcessor.process();
            generatorProcessor.process();
        }
        catch (IOException e) {
            throw new EngineGenerateMojoException("Loading saved configuration failed", e);
        }
        catch (GeneratorException | ParserException e) {
            throw new EngineGenerateMojoException("Execution failed", e);
        }
    }
}

