/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.internal;

import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.TaskGenerateHilla;
import java.io.File;
import java.nio.file.Path;
import java.util.List;

@NpmPackage.Container(value={@NpmPackage(value="@hilla/generator-typescript-core", version="1.3.2"), @NpmPackage(value="@hilla/generator-typescript-utils", version="1.3.2"), @NpmPackage(value="@hilla/generator-typescript-cli", version="1.3.2"), @NpmPackage(value="@hilla/generator-typescript-plugin-client", version="1.3.2"), @NpmPackage(value="@hilla/generator-typescript-plugin-backbone", version="1.3.2"), @NpmPackage(value="@hilla/generator-typescript-plugin-barrel", version="1.3.2"), @NpmPackage(value="@hilla/generator-typescript-plugin-model", version="1.3.2"), @NpmPackage(value="@hilla/generator-typescript-plugin-push", version="1.3.2")})
public class TaskGenerateHillaImpl
implements TaskGenerateHilla {
    static final boolean IS_WINDOWS;
    static final String MAVEN_COMMAND;
    private File projectDirectory;

    public void configure(File projectDirectory, String buildDirectoryName) {
        this.projectDirectory = projectDirectory;
    }

    public void execute() throws ExecutionFailedException {
        List<String> command = this.prepareCommand();
        this.runCodeGeneration(command);
    }

    void runCodeGeneration(List<String> command) throws ExecutionFailedException {
        int exitCode = 0;
        try {
            ProcessBuilder builder = new ProcessBuilder(command).directory(this.projectDirectory).inheritIO();
            exitCode = builder.start().waitFor();
        }
        catch (Exception e) {
            throw new ExecutionFailedException("Hilla Generator execution failed", (Throwable)e);
        }
        if (exitCode != 0) {
            throw new ExecutionFailedException("Hilla Generator execution failed with exit code " + exitCode);
        }
    }

    boolean isMavenProject(Path path) {
        return path.resolve("pom.xml").toFile().exists();
    }

    private boolean isGradleProject(Path path) {
        return path.resolve("build.gradle").toFile().exists();
    }

    List<String> prepareCommand() {
        if (this.projectDirectory.isDirectory()) {
            Path path = this.projectDirectory.toPath();
            if (this.isMavenProject(path)) {
                return this.prepareMavenCommand();
            }
            if (this.isGradleProject(path)) {
                return this.prepareGradleCommand();
            }
        }
        throw new IllegalStateException(String.format("Failed to determine project directory for dev mode. Directory '%s' does not look like a Maven or Gradle project.", this.projectDirectory));
    }

    List<String> prepareMavenCommand() {
        return List.of(MAVEN_COMMAND, "hilla:generate");
    }

    List<String> prepareGradleCommand() {
        throw new UnsupportedOperationException("Gradle is not supported yet");
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = osName.contains("windows");
        MAVEN_COMMAND = IS_WINDOWS ? "mvn.cmd" : "mvn";
    }
}

