/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.internal;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.GeneratorException;
import dev.hilla.engine.GeneratorProcessor;
import dev.hilla.internal.AbstractTaskEndpointGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGenerateEndpointImpl
extends AbstractTaskEndpointGenerator
implements TaskGenerateEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskGenerateEndpointImpl.class);
    private final String nodeCommand;
    private boolean productionMode;

    TaskGenerateEndpointImpl(File projectDirectory, String buildDirectoryName, File outputDirectory, boolean productionMode, String nodeCommand) {
        super(projectDirectory, buildDirectoryName, outputDirectory);
        this.productionMode = productionMode;
        this.nodeCommand = nodeCommand;
    }

    public void execute() throws ExecutionFailedException {
        try {
            EngineConfiguration engineConfiguration = this.getEngineConfiguration();
            GeneratorProcessor processor = new GeneratorProcessor(engineConfiguration, this.nodeCommand);
            processor.process();
        }
        catch (GeneratorException e) {
            LOGGER.error("Failed to run TypeScript endpoint generator", (Throwable)e);
            throw new ExecutionFailedException("Failed to run TypeScript endpoint generator");
        }
        if (!this.productionMode) {
            try {
                this.addDevTools();
            }
            catch (IOException e) {
                throw new ExecutionFailedException("Failed to add devtools", (Throwable)e);
            }
        }
    }

    private void addDevTools() throws IOException {
        File vaadinTs = new File(this.outputDirectory, "vaadin.ts");
        if (vaadinTs.exists()) {
            Object current = FileUtils.readFileToString((File)vaadinTs, (Charset)StandardCharsets.UTF_8);
            current = (String)current + "//@ts-ignore\nif (import.meta.env.DEV) {\n    import(\"Frontend/generated/jar-resources/dev-tools-database.js\");\n}\n";
            FileUtils.writeStringToFile((File)vaadinTs, (String)current, (Charset)StandardCharsets.UTF_8);
        } else {
            LOGGER.error("Unable to add dev tools plugin to vaadin.ts");
        }
    }
}

