/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.gradle.plugin;

import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.GeneratorConfiguration;
import dev.hilla.engine.ParserConfiguration;
import dev.hilla.gradle.plugin.EngineConfigureTask;
import dev.hilla.gradle.plugin.EngineProjectExtension;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Ldev/hilla/gradle/plugin/EngineConfigureTask;", "Lorg/gradle/api/DefaultTask;", "()V", "sourceSets", "Lorg/gradle/api/tasks/SourceSetContainer;", "getSourceSets", "()Lorg/gradle/api/tasks/SourceSetContainer;", "sourceSets$delegate", "Lkotlin/Lazy;", "engineConfigure", "", "hilla-gradle-plugin"})
public class EngineConfigureTask
extends DefaultTask {
    @NotNull
    private final Lazy sourceSets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SourceSetContainer>(this){
        final /* synthetic */ EngineConfigureTask this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final SourceSetContainer invoke() {
            return (SourceSetContainer)this.this$0.getProject().getExtensions().getByType(SourceSetContainer.class);
        }
    }));

    public EngineConfigureTask() {
        this.setGroup("Hilla");
        this.setDescription("Hilla Configure Task");
    }

    private final SourceSetContainer getSourceSets() {
        Lazy lazy = this.sourceSets$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (SourceSetContainer)object;
    }

    @TaskAction
    public final void engineConfigure() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        EngineProjectExtension extension = EngineProjectExtension.Companion.get(project);
        this.getLogger().info("Running the engineConfigure task with effective configuration " + extension);
        GeneratorConfiguration generator = new GeneratorConfiguration();
        ParserConfiguration parser = new ParserConfiguration();
        if (!((Collection)extension.getExposedPackagesToParser()).isEmpty()) {
            parser.setPackages(extension.getExposedPackagesToParser());
        }
        Path projectBuildDir = this.getProject().getBuildDir().toPath();
        Path projectClassesDir = projectBuildDir.resolve("classes");
        Object object = this.getSourceSets().getByName(extension.getSourceSetName());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.api.tasks.SourceSet");
        List<String> classPathElements2 = ((Set)((SourceSet)object).getRuntimeClasspath().getElements().get()).stream().map(arg_0 -> EngineConfigureTask.engineConfigure$lambda$0(engineConfigure.classPathElements.1.INSTANCE, arg_0)).toList();
        EngineConfiguration conf = new EngineConfiguration.Builder(this.getProject().getProjectDir().toPath()).classPath((Collection)classPathElements2).outputDir(extension.getGeneratedTsFolder().toPath()).generator(generator).parser(parser).buildDir(extension.getProjectBuildDir()).classesDir(projectClassesDir).create();
        Path path = this.getProject().getProjectDir().toPath().resolve(projectBuildDir);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path configDir = path;
        Files.createDirectories(configDir, new FileAttribute[0]);
        conf.store(configDir.resolve("hilla-engine-configuration.json").toFile());
    }

    private static final String engineConfigure$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

