/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.maven;

import dev.hilla.maven.EndpointCodeGeneratorMojoException;
import dev.hilla.maven.GeneratorConfiguration;
import dev.hilla.maven.GeneratorException;
import dev.hilla.maven.GeneratorProcessor;
import dev.hilla.maven.ParserConfiguration;
import dev.hilla.maven.ParserException;
import dev.hilla.maven.ParserProcessor;
import dev.hilla.parser.utils.OpenAPIPrinter;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public final class EndpointCodeGeneratorMojo
extends AbstractMojo {
    private static final String[] openAPIFileRelativePath = new String[]{"generated-resources", "openapi.json"};
    @Parameter(readonly=true)
    private final GeneratorConfiguration generator = new GeneratorConfiguration();
    @Parameter(readonly=true)
    private final ParserConfiguration parser = new ParserConfiguration();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean runNpmInstall;

    public void execute() throws EndpointCodeGeneratorMojoException {
        OpenAPI result = this.parseJavaCode();
        this.saveOpenAPI(result);
        this.generateTypeScriptCode(result);
    }

    private void generateTypeScriptCode(OpenAPI openAPI) throws EndpointCodeGeneratorMojoException {
        Log logger = this.getLog();
        try {
            GeneratorProcessor executor = new GeneratorProcessor(this.project, logger, this.runNpmInstall).input(new OpenAPIPrinter().writeAsString(openAPI)).verbose(logger.isDebugEnabled());
            this.generator.getOutputDir().ifPresent(executor::outputDir);
            this.generator.getPlugins().ifPresent(executor::plugins);
            executor.process();
        }
        catch (GeneratorException | IOException | InterruptedException e) {
            throw new EndpointCodeGeneratorMojoException("TS code generation failed", e);
        }
    }

    private void saveOpenAPI(OpenAPI openAPI) throws EndpointCodeGeneratorMojoException {
        try {
            Log logger = this.getLog();
            Path openAPIFile = Paths.get(this.project.getBuild().getDirectory(), openAPIFileRelativePath);
            logger.debug((CharSequence)("Saving OpenAPI file to " + openAPIFile));
            Files.createDirectories(openAPIFile.getParent(), new FileAttribute[0]);
            Files.write(openAPIFile, new OpenAPIPrinter().pretty().writeAsString(openAPI).getBytes(), new OpenOption[0]);
            logger.debug((CharSequence)"OpenAPI file saved");
        }
        catch (IOException e) {
            throw new EndpointCodeGeneratorMojoException("Saving OpenAPI file failed", e);
        }
    }

    private OpenAPI parseJavaCode() throws EndpointCodeGeneratorMojoException {
        try {
            ParserProcessor executor = new ParserProcessor(this.project, this.getLog());
            this.parser.getClassPath().ifPresent(executor::classPath);
            this.parser.getEndpointAnnotation().ifPresent(executor::endpointAnnotation);
            this.parser.getEndpointExposedAnnotation().ifPresent(executor::endpointExposedAnnotation);
            this.parser.getPlugins().ifPresent(executor::plugins);
            this.parser.getOpenAPIPath().ifPresent(executor::openAPIBase);
            return executor.process();
        }
        catch (ParserException e) {
            throw new EndpointCodeGeneratorMojoException("Java code parsing failed", e);
        }
    }
}

