/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.maven;

import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.GeneratorConfiguration;
import dev.hilla.engine.ParserConfiguration;
import dev.hilla.maven.EngineConfigureMojoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="configure", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class EngineConfigureMojo
extends AbstractMojo {
    @Parameter(readonly=true)
    private final GeneratorConfiguration generator = new GeneratorConfiguration();
    @Parameter(readonly=true)
    private final ParserConfiguration parser = new ParserConfiguration();
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/frontend/generated")
    private File generatedTsFolder;

    public void execute() throws EngineConfigureMojoException {
        try {
            EngineConfiguration conf = new EngineConfiguration();
            conf.setClassPath(new LinkedHashSet(this.project.getRuntimeClasspathElements()));
            conf.setBaseDir(this.project.getBasedir().toPath());
            conf.setOutputDir(this.generatedTsFolder.toPath());
            conf.setGenerator(this.generator);
            conf.setParser(this.parser);
            String buildDir = this.project.getBuild().getDirectory();
            conf.setBuildDir(buildDir);
            conf.setClassesDir(this.project.getBuild().getOutputDirectory());
            Path configDir = this.project.getBasedir().toPath().resolve(buildDir);
            Files.createDirectories(configDir, new FileAttribute[0]);
            conf.store(configDir.toFile());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new EngineConfigureMojoException("Configuration failed", e);
        }
        catch (IOException e) {
            throw new EngineConfigureMojoException("Maven configuration has not been saved to file", e);
        }
    }
}

