/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.theme.lumo;

import com.vaadin.flow.theme.AbstractTheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class Lumo
implements AbstractTheme {
    public static final String LIGHT = "light";
    public static final String DARK = "dark";

    public String getBaseUrl() {
        return "src/";
    }

    public String getThemeUrl() {
        return "theme/lumo/";
    }

    public Map<String, String> getHtmlAttributes(String variant) {
        if (variant.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        switch (variant) {
            case "light": {
                attributes.put("theme", LIGHT);
                break;
            }
            case "dark": {
                attributes.put("theme", DARK);
                break;
            }
            default: {
                LoggerFactory.getLogger((String)Lumo.class.getName()).warn("Lumo theme variant not recognized: '{}'. Using no variant.", (Object)variant);
            }
        }
        return attributes;
    }
}

