/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotatedModel;
import dev.hilla.parser.models.AnnotationInfoModel;
import io.github.classgraph.AnnotationInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

abstract class AnnotatedAbstractModel
implements AnnotatedModel {
    private List<AnnotationInfoModel> annotations;

    AnnotatedAbstractModel() {
    }

    protected static List<AnnotationInfoModel> processAnnotations(@Nonnull Annotation[] annotations) {
        return Arrays.stream(annotations).map(AnnotationInfoModel::of).collect(Collectors.toList());
    }

    protected static List<AnnotationInfoModel> processAnnotations(List<AnnotationInfo> annotations) {
        return annotations != null ? AnnotatedAbstractModel.processAnnotations(annotations.stream()) : List.of();
    }

    protected static List<AnnotationInfoModel> processAnnotations(Stream<AnnotationInfo> annotations) {
        return annotations.map(AnnotationInfoModel::of).collect(Collectors.toList());
    }

    @Override
    public List<AnnotationInfoModel> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.prepareAnnotations();
        }
        return this.annotations;
    }

    protected abstract List<AnnotationInfoModel> prepareAnnotations();
}

