/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.core.SharedStorage;
import dev.hilla.parser.utils.PluginException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class AbstractCompositePlugin<C extends PluginConfiguration>
extends AbstractPlugin<C> {
    private final LinkedList<Plugin> plugins = new LinkedList();

    protected AbstractCompositePlugin(Plugin ... plugins) {
        Stream.of(plugins).map(Objects::requireNonNull).sorted(Comparator.comparingInt(Plugin::getOrder)).forEachOrdered(this.plugins::add);
        this.verifyPluginsOrder();
    }

    @Override
    public void enter(NodePath<?> nodePath) {
        this.plugins.iterator().forEachRemaining(plugin -> plugin.enter(nodePath));
    }

    @Override
    public void exit(NodePath<?> nodePath) {
        this.plugins.descendingIterator().forEachRemaining(plugin -> plugin.exit(nodePath));
    }

    @Override
    @Nonnull
    public Node<?, ?> resolve(@Nonnull Node<?, ?> node, @Nonnull NodePath<?> parentPath) {
        for (Plugin plugin : this.plugins) {
            node = plugin.resolve(node, parentPath);
        }
        return node;
    }

    @Override
    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        for (Plugin plugin : this.plugins) {
            nodeDependencies = plugin.scan(nodeDependencies);
        }
        return nodeDependencies;
    }

    @Override
    public void setStorage(SharedStorage storage) {
        super.setStorage(storage);
        this.plugins.iterator().forEachRemaining(plugin -> plugin.setStorage(storage));
    }

    private void verifyPluginsOrder() {
        HashSet previous = new HashSet();
        for (Plugin plugin : this.plugins) {
            for (Class<? extends Plugin> requiredPluginCls : plugin.getRequiredPlugins()) {
                if (previous.contains(requiredPluginCls)) continue;
                throw new PluginException(String.format("Plugin %s must be run after %s", plugin.getClass(), requiredPluginCls));
            }
            previous.add(plugin.getClass());
        }
    }
}

