/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.core.SharedStorage;
import java.lang.reflect.ParameterizedType;

public abstract class AbstractPlugin<C extends PluginConfiguration>
implements Plugin {
    private C configuration;
    private int order;
    private SharedStorage storage;

    protected AbstractPlugin() {
    }

    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(PluginConfiguration configuration) {
        if (configuration == null) {
            this.configuration = null;
            return;
        }
        Class configClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (configClass.equals(PluginConfiguration.class)) {
            throw new IllegalArgumentException(String.format("The '%s' plugin does not expect configuration set", this.getClass().getName()));
        }
        if (!configClass.isAssignableFrom(configuration.getClass())) {
            throw new IllegalArgumentException(String.format("Requires instance of %s , but got %s", configClass, configuration.getClass()));
        }
        this.configuration = configuration;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    protected SharedStorage getStorage() {
        return this.storage;
    }

    @Override
    public void setStorage(SharedStorage storage) {
        this.storage = storage;
    }
}

