/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassRefSignatureModel;
import dev.hilla.parser.models.FieldInfoModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.PackageInfoModel;
import dev.hilla.parser.models.ReflectionModel;
import dev.hilla.parser.models.TypeParameterModel;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class ClassInfoReflectionModel
extends ClassInfoModel
implements ReflectionModel {
    private final Class<?> origin;

    ClassInfoReflectionModel(Class<?> origin) {
        this.origin = origin;
    }

    @Override
    public Class<?> get() {
        return this.origin;
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public String getSimpleName() {
        return this.origin.getSimpleName();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.origin.getModifiers());
    }

    @Override
    public boolean isAnnotation() {
        return this.origin.isAnnotation();
    }

    @Override
    public boolean isArrayClass() {
        return this.origin.isArray();
    }

    @Override
    public boolean isBigDecimal() {
        return ClassInfoModel.isAssignableFrom(BigDecimal.class, this.origin);
    }

    @Override
    public boolean isBigInteger() {
        return ClassInfoModel.isAssignableFrom(BigInteger.class, this.origin);
    }

    @Override
    public boolean isBoolean() {
        return ClassInfoModel.isAssignableFrom(Boolean.class, this.origin);
    }

    @Override
    public boolean isByte() {
        return ClassInfoModel.isAssignableFrom(Byte.class, this.origin);
    }

    @Override
    public boolean isCharacter() {
        return ClassInfoModel.isAssignableFrom(Character.class, this.origin);
    }

    @Override
    public boolean isDate() {
        return ClassInfoReflectionModel.isDateAssignable(this.origin, ClassInfoModel::isAssignableFrom);
    }

    @Override
    public boolean isDateTime() {
        return ClassInfoReflectionModel.isDateTimeAssignable(this.origin, ClassInfoModel::isAssignableFrom);
    }

    @Override
    public boolean isDouble() {
        return ClassInfoModel.isAssignableFrom(Double.class, this.origin);
    }

    @Override
    public boolean isEnum() {
        return this.origin.isEnum();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.origin.getModifiers());
    }

    @Override
    public boolean isFloat() {
        return ClassInfoModel.isAssignableFrom(Float.class, this.origin);
    }

    @Override
    public boolean isInteger() {
        return ClassInfoModel.isAssignableFrom(Integer.class, this.origin);
    }

    @Override
    public boolean isInterface() {
        return this.origin.isInterface() && !this.origin.isAnnotation();
    }

    @Override
    public boolean isInterfaceOrAnnotation() {
        return this.isInterface() || this.isAnnotation();
    }

    @Override
    public boolean isIterable() {
        return ClassInfoModel.isAssignableFrom(Iterable.class, this.origin);
    }

    @Override
    public boolean isJDKClass() {
        return ClassInfoModel.isJDKClass(this.origin);
    }

    @Override
    public boolean isLong() {
        return ClassInfoModel.isAssignableFrom(Long.class, this.origin);
    }

    @Override
    public boolean isMap() {
        return ClassInfoModel.isAssignableFrom(Map.class, this.origin);
    }

    @Override
    public boolean isNativeObject() {
        return ClassInfoModel.is(this.origin, Object.class);
    }

    @Override
    public boolean isOptional() {
        return ClassInfoModel.isAssignableFrom(Optional.class, this.origin);
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.origin.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.origin.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.origin.getModifiers());
    }

    @Override
    public boolean isShort() {
        return ClassInfoModel.isAssignableFrom(Short.class, this.origin);
    }

    @Override
    public boolean isStandardClass() {
        return !this.isAnnotation() && !this.isInterface();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.origin.getModifiers());
    }

    @Override
    public boolean isString() {
        return ClassInfoModel.isAssignableFrom(String.class, this.origin);
    }

    @Override
    public boolean isSynthetic() {
        return this.origin.isSynthetic();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return ClassInfoReflectionModel.processAnnotations(this.origin.getAnnotations());
    }

    @Override
    protected List<FieldInfoModel> prepareFields() {
        return Arrays.stream(this.origin.getDeclaredFields()).map(FieldInfoModel::of).sorted(FieldInfoModel.FIELD_ORDER).collect(Collectors.toList());
    }

    @Override
    protected List<ClassInfoModel> prepareInnerClasses() {
        return Arrays.stream(this.origin.getDeclaredClasses()).map(ClassInfoModel::of).sorted(CLASS_ORDER).collect(Collectors.toList());
    }

    @Override
    protected List<ClassRefSignatureModel> prepareInterfaces() {
        return Arrays.stream(this.origin.getAnnotatedInterfaces()).map(ClassRefSignatureModel::of).collect(Collectors.toList());
    }

    @Override
    protected List<MethodInfoModel> prepareMethods() {
        return Arrays.stream(this.origin.getDeclaredMethods()).map(MethodInfoModel::of).sorted(MethodInfoModel.METHOD_ORDER).collect(Collectors.toList());
    }

    @Override
    protected PackageInfoModel preparePackage() {
        return PackageInfoModel.of(this.origin.getPackage());
    }

    @Override
    protected ClassRefSignatureModel prepareSuperClass() {
        AnnotatedType superClass = this.origin.getAnnotatedSuperclass();
        return superClass != null && ClassInfoModel.isNonJDKClass(superClass) ? ClassRefSignatureModel.of(superClass) : null;
    }

    @Override
    protected List<TypeParameterModel> prepareTypeParameters() {
        return Arrays.stream(this.origin.getTypeParameters()).map(TypeParameterModel::of).collect(Collectors.toList());
    }
}

