/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.PackageInfoModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PackageInfoReflectionModel
extends PackageInfoModel {
    private final Package origin;

    PackageInfoReflectionModel(Package origin) {
        this.origin = origin;
    }

    @Override
    public Package get() {
        return this.origin;
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return PackageInfoReflectionModel.processAnnotations(this.origin.getDeclaredAnnotations());
    }

    @Override
    public List<PackageInfoModel> getAncestors() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return PackageInfoReflectionModel.getAllAncestorPackageNames(this.origin.getName()).map(classLoader::getDefinedPackage).filter(Objects::nonNull).map(PackageInfoModel::of).collect(Collectors.toList());
    }

    private static Stream<String> getAllAncestorPackageNames(String packageName) {
        return Stream.iterate(packageName, p -> p.contains("."), p -> p.substring(0, p.lastIndexOf(46)));
    }
}

