/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models.jackson;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import dev.hilla.parser.models.AnnotatedModel;
import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassMemberModel;
import dev.hilla.parser.models.FieldInfoModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.Model;
import dev.hilla.parser.models.NamedModel;
import dev.hilla.parser.models.OwnedModel;
import dev.hilla.parser.models.ReflectionModel;
import dev.hilla.parser.models.jackson.JacksonModel;
import dev.hilla.parser.models.jackson.JacksonPropertyTypeModel;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JacksonPropertyModel
extends JacksonModel<FieldInfoModel, MethodInfoModel, MethodInfoModel>
implements NamedModel,
OwnedModel<ClassInfoModel>,
ReflectionModel {
    private ClassInfoModel owner;
    private JacksonPropertyTypeModel type;

    private JacksonPropertyModel(BeanPropertyDefinition origin) {
        super(origin);
    }

    public static JacksonPropertyModel of(@Nonnull BeanPropertyDefinition origin) {
        return new JacksonPropertyModel(Objects.requireNonNull(origin));
    }

    public boolean couldDeserialize() {
        return this.origin.couldDeserialize();
    }

    public Optional<? extends ClassMemberModel> getAccessor() {
        if (this.origin.hasGetter()) {
            return this.getGetter();
        }
        if (this.origin.hasField()) {
            return this.getField();
        }
        return Optional.empty();
    }

    @Override
    public Class<? extends Model> getCommonModelClass() {
        return JacksonPropertyModel.class;
    }

    public Optional<? extends ClassMemberModel> getMutator() {
        if (this.origin.hasSetter()) {
            return this.getSetter();
        }
        if (this.origin.hasField()) {
            return this.getField();
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public ClassInfoModel getOwner() {
        if (this.owner == null) {
            this.owner = (ClassInfoModel)this.getPrimaryMember().getOwner();
        }
        return this.owner;
    }

    public ClassMemberModel getPrimaryMember() {
        if (this.origin.hasGetter()) {
            return (ClassMemberModel)this.getGetter().get();
        }
        if (this.origin.hasSetter()) {
            return (ClassMemberModel)this.getSetter().get();
        }
        return (ClassMemberModel)this.getField().get();
    }

    public JacksonPropertyTypeModel getType() {
        if (this.type == null) {
            this.type = JacksonPropertyTypeModel.of(this.origin);
        }
        return this.type;
    }

    public boolean isExplicitlyIncluded() {
        return this.origin.isExplicitlyIncluded();
    }

    public String toString() {
        return "JacksonPropertyModel[" + this.origin + "]";
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return Stream.of(this.getField().map(AnnotatedModel::getAnnotations), this.getGetter().map(AnnotatedModel::getAnnotations), this.getSetter().map(m -> m.getParameters().get(0).getAnnotations())).flatMap(Optional::stream).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected FieldInfoModel prepareField() {
        return this.origin.hasField() ? FieldInfoModel.of(this.origin.getField().getAnnotated()) : null;
    }

    @Override
    protected MethodInfoModel prepareGetter() {
        return this.origin.hasGetter() ? MethodInfoModel.of(this.origin.getGetter().getAnnotated()) : null;
    }

    @Override
    protected MethodInfoModel prepareSetter() {
        return this.origin.hasSetter() ? MethodInfoModel.of(this.origin.getSetter().getAnnotated()) : null;
    }
}

