/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models.jackson;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import dev.hilla.parser.models.AnnotatedModel;
import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.Model;
import dev.hilla.parser.models.ReflectionModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.models.jackson.JacksonModel;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JacksonPropertyTypeModel
extends JacksonModel<SignatureModel, SignatureModel, SignatureModel>
implements ReflectionModel {
    private JacksonPropertyTypeModel(BeanPropertyDefinition origin) {
        super(origin);
    }

    public static JacksonPropertyTypeModel of(@Nonnull BeanPropertyDefinition origin) {
        return new JacksonPropertyTypeModel(Objects.requireNonNull(origin));
    }

    @Override
    public Class<? extends Model> getCommonModelClass() {
        return JacksonPropertyTypeModel.class;
    }

    public SignatureModel getPrimary() {
        Optional<Object> type = this.origin.hasGetter() ? this.getGetter() : (this.origin.hasSetter() ? this.getSetter() : this.getField());
        return (SignatureModel)type.get();
    }

    public String toString() {
        return "JacksonPropertyTypeModel[" + this.origin + "]";
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return Stream.of(this.getField(), this.getGetter(), this.getSetter()).flatMap(Optional::stream).map(AnnotatedModel::getAnnotations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected SignatureModel prepareField() {
        return this.origin.hasField() ? SignatureModel.of(this.origin.getField().getAnnotated().getAnnotatedType()) : null;
    }

    @Override
    protected SignatureModel prepareGetter() {
        return this.origin.hasGetter() ? SignatureModel.of(this.origin.getGetter().getAnnotated().getAnnotatedReturnType()) : null;
    }

    @Override
    protected SignatureModel prepareSetter() {
        return this.origin.hasSetter() ? SignatureModel.of(this.origin.getSetter().getAnnotated().getParameters()[0].getAnnotatedType()) : null;
    }
}

