/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.MethodParameterInfoModel;
import dev.hilla.parser.models.ReflectionModel;
import dev.hilla.parser.models.SignatureModel;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;

final class MethodParameterInfoReflectionModel
extends MethodParameterInfoModel
implements ReflectionModel {
    private final Parameter origin;

    MethodParameterInfoReflectionModel(Parameter origin) {
        this.origin = origin;
    }

    @Override
    public Parameter get() {
        return this.origin;
    }

    @Override
    public int getModifiers() {
        return this.origin.getModifiers();
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.origin.getModifiers());
    }

    @Override
    public boolean isImplicit() {
        return this.origin.isImplicit();
    }

    @Override
    public boolean isMandated() {
        return this.origin.isImplicit();
    }

    @Override
    public boolean isSynthetic() {
        return this.origin.isSynthetic();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return MethodParameterInfoReflectionModel.processAnnotations(this.origin.getAnnotations());
    }

    @Override
    protected int prepareIndex() {
        Parameter[] parameters = this.origin.getDeclaringExecutable().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals(this.origin)) continue;
            return i;
        }
        throw new IllegalStateException("The parameter has not been found in the method parameter list");
    }

    @Override
    protected MethodInfoModel prepareOwner() {
        return MethodInfoModel.of(this.origin.getDeclaringExecutable());
    }

    @Override
    protected SignatureModel prepareType() {
        return SignatureModel.of(this.origin.getAnnotatedType());
    }
}

