/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.MethodParameterInfoModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.models.SourceModel;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.MethodParameterInfo;
import java.util.List;

final class MethodParameterInfoSourceModel
extends MethodParameterInfoModel
implements SourceModel {
    private final MethodParameterInfo origin;

    MethodParameterInfoSourceModel(MethodParameterInfo origin) {
        this.origin = origin;
    }

    public MethodParameterInfo get() {
        return this.origin;
    }

    @Override
    public int getModifiers() {
        return this.origin.getModifiers();
    }

    @Override
    public String getName() {
        return this.origin.getName() == null ? "arg" + this.getIndex() : this.origin.getName();
    }

    @Override
    public boolean isFinal() {
        return this.origin.isFinal();
    }

    @Override
    public boolean isImplicit() {
        return this.origin.isMandated();
    }

    @Override
    public boolean isMandated() {
        return this.origin.isMandated();
    }

    @Override
    public boolean isSynthetic() {
        return this.origin.isSynthetic();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return MethodParameterInfoSourceModel.processAnnotations((List<AnnotationInfo>)this.origin.getAnnotationInfo());
    }

    @Override
    protected int prepareIndex() {
        MethodParameterInfo[] parameters = this.origin.getMethodInfo().getParameterInfo();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals((Object)this.origin)) continue;
            return i;
        }
        throw new IllegalStateException("The parameter has not been found in the method parameter list");
    }

    @Override
    protected MethodInfoModel prepareOwner() {
        return MethodInfoModel.of(this.origin.getMethodInfo());
    }

    @Override
    protected SignatureModel prepareType() {
        return SignatureModel.of((HierarchicalTypeSignature)this.origin.getTypeSignatureOrTypeDescriptor());
    }
}

