/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.model;

import dev.hilla.parser.core.AssociationMap;
import dev.hilla.parser.models.SignatureModel;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.TypeSignature;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ValidationConstraint {
    private final Map<String, Object> attributes;
    private final String simpleName;

    private ValidationConstraint(@Nonnull String simpleName, Map<String, Object> attributes) {
        this.simpleName = simpleName;
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public String getSimpleName() {
        return this.simpleName;
    }

    static class Processor {
        private static final String VALIDATION_CONSTRAINTS_KEY = "x-validation-constraints";
        private static final String VALIDATION_CONSTRAINTS_PACKAGE_NAME = "javax.validation.constraints";
        private final AssociationMap map;

        public Processor(@Nonnull AssociationMap map) {
            this.map = map;
        }

        public void process() {
            this.map.getSignatures().forEach(this::processSchema);
        }

        private ValidationConstraint convertAnnotation(AnnotationInfo annotationInfo) {
            String simpleName = this.extractSimpleName(annotationInfo.getName());
            Map<String, Object> attributes = annotationInfo.getParameterValues().stream().collect(Collectors.toMap(AnnotationParameterValue::getName, AnnotationParameterValue::getValue));
            return new ValidationConstraint(simpleName, attributes.size() > 0 ? attributes : null);
        }

        private String extractPackageName(String fullyQualifiedName) {
            return fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf("."));
        }

        private String extractSimpleName(String fullyQualifiedName) {
            return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
        }

        private boolean isValidationConstraintAnnotation(AnnotationInfo annotationInfo) {
            return this.extractPackageName(annotationInfo.getName()).equals(VALIDATION_CONSTRAINTS_PACKAGE_NAME);
        }

        private void processSchema(Schema<?> schema, SignatureModel signature) {
            List constraints;
            if (!(signature.get() instanceof TypeSignature)) {
                return;
            }
            AnnotationInfoList annotationInfoList = ((TypeSignature)signature.get()).getTypeAnnotationInfo();
            if (annotationInfoList != null && !(constraints = annotationInfoList.stream().filter(this::isValidationConstraintAnnotation).map(this::convertAnnotation).collect(Collectors.toList())).isEmpty()) {
                schema.addExtension(VALIDATION_CONSTRAINTS_KEY, constraints);
            }
        }
    }
}

