/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class AnnotatedOwnerUtils {
    private static final Function<AnnotatedType, List<Annotation[]>> annotationsGetter;

    public static List<Annotation[]> getAllOwnersAnnotations(AnnotatedType type) {
        return annotationsGetter.apply(type);
    }

    private static List<Annotation[]> getDefaultAnnotations(AnnotatedType type) {
        ArrayList<Annotation[]> list = new ArrayList<Annotation[]>();
        while (type != null) {
            list.add(type.getAnnotations());
            type = type.getAnnotatedOwnerType();
        }
        return list;
    }

    private static List<Annotation[]> getJDK11Annotations(AnnotatedType type) {
        ArrayList<Annotation[]> list = new ArrayList<Annotation[]>();
        AnnotatedType child = null;
        boolean isChildStatic = false;
        while (type != null) {
            Class<?> typeCls = AnnotatedOwnerUtils.resolve(type);
            boolean isTypeStatic = Modifier.isStatic(typeCls.getModifiers());
            boolean isTypeParametrized = type instanceof AnnotatedParameterizedType;
            AnnotatedType owner = type.getAnnotatedOwnerType();
            Annotation[] annotations = null;
            if (!(owner == null || child != null && isChildStatic && isTypeStatic)) {
                Class<?> ownerCls = AnnotatedOwnerUtils.resolve(owner);
                boolean isOwnerStatic = Modifier.isStatic(ownerCls.getModifiers());
                boolean isOwnerParametrized = owner instanceof AnnotatedParameterizedType;
                if (isTypeStatic || !isTypeStatic && isOwnerStatic && isOwnerParametrized) {
                    annotations = owner.getAnnotations();
                }
            }
            if (annotations == null && (child == null || !isChildStatic && !isTypeStatic || !isChildStatic && isTypeStatic && !isTypeParametrized)) {
                annotations = type.getAnnotations();
            }
            list.add(annotations != null ? annotations : new Annotation[]{});
            child = type;
            isChildStatic = isTypeStatic;
            type = type.getAnnotatedOwnerType();
        }
        return list;
    }

    private static Class<?> resolve(AnnotatedType type) {
        return type instanceof AnnotatedParameterizedType ? (Class)((ParameterizedType)type.getType()).getRawType() : (Class)type.getType();
    }

    static {
        boolean isJDK11 = Runtime.Version.parse(System.getProperty("java.version")).feature() <= 11;
        annotationsGetter = isJDK11 ? AnnotatedOwnerUtils::getJDK11Annotations : AnnotatedOwnerUtils::getDefaultAnnotations;
    }
}

