/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.plugin.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HillaAppInitUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(HillaAppInitUtility.class);
    private static final String REACT_SKELETON = "https://github.com/vaadin/skeleton-starter-hilla-react/archive/refs/heads/v2.1.zip";
    private static final List<String> REACT_FILE_LIST = List.of("package.json", "package-lock.json", "types.d.ts", "vite.config.ts", "frontend/App.tsx", "frontend/index.ts", "frontend/routes.tsx", "frontend/views/MainView.tsx", "src/main/java/org/vaadin/example/endpoints/HelloEndpoint.java");
    private static final String LIT_SKELETON = "https://github.com/vaadin/skeleton-starter-hilla-lit/archive/refs/heads/v2.1.zip";
    private static final List<String> LIT_FILE_LIST = List.of("package.json", "package-lock.json", "vite.config.ts", "frontend/index.ts", "frontend/routes.ts", "frontend/views/main-view.ts", "src/main/java/org/vaadin/example/endpoints/HelloEndpoint.java");

    public static void scaffold(Path projectDirectory, List<String> dependencyArtifactIds) throws IOException {
        Framework framework = HillaAppInitUtility.detectFramework(dependencyArtifactIds);
        Path zipFile = Files.createTempFile("hilla-scaffold", ".zip", new FileAttribute[0]);
        zipFile.toFile().deleteOnExit();
        try (InputStream is = new URL(framework.getSkeletonUrl()).openStream();){
            Files.copy(is, zipFile, StandardCopyOption.REPLACE_EXISTING);
        }
        try (ZipFile zip = new ZipFile(zipFile.toFile());){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().contains("/")) continue;
                String item = entry.getName().split("/", 2)[1];
                if (!framework.getItems().contains(item)) continue;
                if (item.endsWith("Endpoint.java")) {
                    String applicationPackage = HillaAppInitUtility.findSpringBootApplicationPackage(projectDirectory);
                    String applicationPath = applicationPackage.replace(".", "/");
                    String content = new String(zip.getInputStream(entry).readAllBytes());
                    content = content.replace("org.vaadin.example", applicationPackage);
                    Path path = projectDirectory.resolve(item = item.replace("org/vaadin/example", applicationPath));
                    Path parent = path.getParent();
                    if (parent != null) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    LOGGER.info("Adding endpoint {}", (Object)item);
                    Files.writeString(path, (CharSequence)content, new OpenOption[0]);
                    continue;
                }
                LOGGER.info("Extracting {}", (Object)item);
                Path path = projectDirectory.resolve(item);
                Path parent = path.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy(zip.getInputStream(entry), path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static Framework detectFramework(List<String> dependencyArtifactIds) {
        if (dependencyArtifactIds.stream().anyMatch(artifactId -> artifactId.contains("hilla-react"))) {
            return Framework.REACT;
        }
        if (dependencyArtifactIds.stream().anyMatch(artifactId -> artifactId.contains("hilla"))) {
            return Framework.LIT;
        }
        throw new RuntimeException("No hilla starter found! To use hilla:init-app maven goal (or hillaInitApp task in gradle), you must either have 'hilla-react-spring-boot-starter' or 'hilla-spring-boot-starter' in the list of your dependencies. %nPlease take a look at https://github.com/vaadin/skeleton-starter-hilla-react or https://github.com/vaadin/skeleton-starter-hilla-lit as a reference.");
    }

    private static String findSpringBootApplicationPackage(Path projectDirectory) throws IOException {
        try (Stream<Path> paths = Files.walk(projectDirectory.resolve("src/main"), new FileVisitOption[0]);){
            String string = paths.filter(path -> !path.toString().contains("/resources/")).filter(path -> path.toFile().isFile() && !path.toFile().getName().startsWith(".")).filter(path -> {
                try {
                    String content = Files.readString(path);
                    return content.contains("@SpringBootApplication");
                }
                catch (IOException e) {
                    LOGGER.error("Error reading file: {}", path, (Object)e);
                    return false;
                }
            }).map(HillaAppInitUtility::extractPackage).findFirst().orElseThrow(() -> new RuntimeException("No class annotated with @SpringBootApplication found!"));
            return string;
        }
    }

    private static String extractPackage(Path path) {
        try {
            String content = Files.readString(path);
            String regexToExcludeCommentsAndStringLiterals = "//.*|(\"(?:\\\\[^\"]|\\\\\"|.)*?\")|(?s)/\\*.*?\\*/";
            String codeWithoutComments = content.replaceAll(regexToExcludeCommentsAndStringLiterals, "");
            String regexToExtractPackage = "package\\b\\s+([a-zA-Z_][\\w.]*)\\s*;";
            Matcher matcher = Pattern.compile(regexToExtractPackage).matcher(codeWithoutComments);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new RuntimeException("Having the class annotated with @SpringBootApplication at the default package is not allowed by the Spring Boot as the component scan will fail during startup.");
        }
        catch (IOException e) {
            String errorMessage = String.format("Error reading file: %s", path);
            LOGGER.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private static enum Framework {
        REACT("https://github.com/vaadin/skeleton-starter-hilla-react/archive/refs/heads/v2.1.zip", REACT_FILE_LIST),
        LIT("https://github.com/vaadin/skeleton-starter-hilla-lit/archive/refs/heads/v2.1.zip", LIT_FILE_LIST);

        private final String skeletonUrl;
        private final List<String> items;

        private Framework(String skeletonUrl, List<String> items) {
            this.skeletonUrl = skeletonUrl;
            this.items = items;
        }

        public String getSkeletonUrl() {
            return this.skeletonUrl;
        }

        public List<String> getItems() {
            return this.items;
        }
    }
}

