package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.client._

/** Pointer for RuleWithOperations */
final case class RuleWithOperationsPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.admissionregistration.v1.RuleWithOperations] {
  def operations : ListPointer[String] = ListPointer(currentPath / s"operations")
  def apiVersions : ListPointer[String] = ListPointer(currentPath / s"apiVersions")
  def scope : Pointer.Plain[String] = Pointer.Plain(currentPath / s"scope")
  def apiGroups : ListPointer[String] = ListPointer(currentPath / s"apiGroups")
  def resources : ListPointer[String] = ListPointer(currentPath / s"resources")
}


