package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.client._

/** Pointer for ServiceReference */
final case class ServiceReferencePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.admissionregistration.v1.ServiceReference] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
  def path : Pointer.Plain[String] = Pointer.Plain(currentPath / s"path")
  def port : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"port")
}


