package io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

/** Pointer for DaemonSetSpec */
final case class DaemonSetSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.DaemonSetSpec] {
  def template :  io.k8s.api.core.v1.PodTemplateSpecPointer = io.k8s.api.core.v1.PodTemplateSpecPointer(currentPath / s"template")
  def selector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
  def minReadySeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReadySeconds")
  def revisionHistoryLimit : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"revisionHistoryLimit")
  def updateStrategy :  io.k8s.api.apps.v1.DaemonSetUpdateStrategyPointer = io.k8s.api.apps.v1.DaemonSetUpdateStrategyPointer(currentPath / s"updateStrategy")
}


