package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.client._

/** Pointer for SubjectAccessReviewStatus */
final case class SubjectAccessReviewStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] {
  def allowed : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"allowed")
  def denied : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"denied")
  def evaluationError : Pointer.Plain[String] = Pointer.Plain(currentPath / s"evaluationError")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
}


