package io.k8s.api.batch.v1

import dev.hnaderi.k8s.client._

/** Pointer for JobSpec */
final case class JobSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.batch.v1.JobSpec] {
  def template :  io.k8s.api.core.v1.PodTemplateSpecPointer = io.k8s.api.core.v1.PodTemplateSpecPointer(currentPath / s"template")
  def parallelism : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"parallelism")
  def completionMode : Pointer.Plain[String] = Pointer.Plain(currentPath / s"completionMode")
  def podFailurePolicy :  io.k8s.api.batch.v1.PodFailurePolicyPointer = io.k8s.api.batch.v1.PodFailurePolicyPointer(currentPath / s"podFailurePolicy")
  def manualSelector : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"manualSelector")
  def suspend : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"suspend")
  def backoffLimit : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"backoffLimit")
  def activeDeadlineSeconds : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"activeDeadlineSeconds")
  def completions : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"completions")
  def ttlSecondsAfterFinished : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"ttlSecondsAfterFinished")
  def selector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
}


