package io.k8s.api.coordination.v1

import dev.hnaderi.k8s.client._

/** Pointer for LeaseSpec */
final case class LeaseSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.coordination.v1.LeaseSpec] {
  def leaseTransitions : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"leaseTransitions")
  def holderIdentity : Pointer.Plain[String] = Pointer.Plain(currentPath / s"holderIdentity")
  def leaseDurationSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"leaseDurationSeconds")
  def renewTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = Pointer.Plain(currentPath / s"renewTime")
  def acquireTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = Pointer.Plain(currentPath / s"acquireTime")
}


