package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for CSIPersistentVolumeSource */
final case class CSIPersistentVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.CSIPersistentVolumeSource] {
  def volumeHandle : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeHandle")
  def driver : Pointer.Plain[String] = Pointer.Plain(currentPath / s"driver")
  def nodeStageSecretRef :  io.k8s.api.core.v1.SecretReferencePointer = io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"nodeStageSecretRef")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def controllerPublishSecretRef :  io.k8s.api.core.v1.SecretReferencePointer = io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"controllerPublishSecretRef")
  def volumeAttributes : MapPointer[String] = MapPointer(currentPath / s"volumeAttributes")
  def controllerExpandSecretRef :  io.k8s.api.core.v1.SecretReferencePointer = io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"controllerExpandSecretRef")
  def nodeExpandSecretRef :  io.k8s.api.core.v1.SecretReferencePointer = io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"nodeExpandSecretRef")
  def nodePublishSecretRef :  io.k8s.api.core.v1.SecretReferencePointer = io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"nodePublishSecretRef")
}


