package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ConfigMap */
final case class ConfigMapPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ConfigMap] {
  def data : MapPointer[String] = MapPointer(currentPath / s"data")
  def immutable : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"immutable")
  def binaryData : MapPointer[String] = MapPointer(currentPath / s"binaryData")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


