package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for DownwardAPIVolumeFile */
final case class DownwardAPIVolumeFilePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.DownwardAPIVolumeFile] {
  def path : Pointer.Plain[String] = Pointer.Plain(currentPath / s"path")
  def fieldRef :  io.k8s.api.core.v1.ObjectFieldSelectorPointer = io.k8s.api.core.v1.ObjectFieldSelectorPointer(currentPath / s"fieldRef")
  def mode : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"mode")
  def resourceFieldRef :  io.k8s.api.core.v1.ResourceFieldSelectorPointer = io.k8s.api.core.v1.ResourceFieldSelectorPointer(currentPath / s"resourceFieldRef")
}


