package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for NFSVolumeSource */
final case class NFSVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.NFSVolumeSource] {
  def path : Pointer.Plain[String] = Pointer.Plain(currentPath / s"path")
  def server : Pointer.Plain[String] = Pointer.Plain(currentPath / s"server")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
}


