package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for NodeSpec */
final case class NodeSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.NodeSpec] {
  def externalID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"externalID")
  def taints : ListPointer[io.k8s.api.core.v1.Taint] = ListPointer(currentPath / s"taints")
  def configSource :  io.k8s.api.core.v1.NodeConfigSourcePointer = io.k8s.api.core.v1.NodeConfigSourcePointer(currentPath / s"configSource")
  def unschedulable : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"unschedulable")
  def podCIDR : Pointer.Plain[String] = Pointer.Plain(currentPath / s"podCIDR")
  def providerID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"providerID")
  def podCIDRs : ListPointer[String] = ListPointer(currentPath / s"podCIDRs")
}


