package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for Secret */
final case class SecretPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Secret] {
  def data : MapPointer[String] = MapPointer(currentPath / s"data")
  def immutable : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"immutable")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def stringData : MapPointer[String] = MapPointer(currentPath / s"stringData")
}


