package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for Volume */
final case class VolumePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Volume] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def secret :  io.k8s.api.core.v1.SecretVolumeSourcePointer = io.k8s.api.core.v1.SecretVolumeSourcePointer(currentPath / s"secret")
  def scaleIO :  io.k8s.api.core.v1.ScaleIOVolumeSourcePointer = io.k8s.api.core.v1.ScaleIOVolumeSourcePointer(currentPath / s"scaleIO")
  def csi :  io.k8s.api.core.v1.CSIVolumeSourcePointer = io.k8s.api.core.v1.CSIVolumeSourcePointer(currentPath / s"csi")
  def azureDisk :  io.k8s.api.core.v1.AzureDiskVolumeSourcePointer = io.k8s.api.core.v1.AzureDiskVolumeSourcePointer(currentPath / s"azureDisk")
  def azureFile :  io.k8s.api.core.v1.AzureFileVolumeSourcePointer = io.k8s.api.core.v1.AzureFileVolumeSourcePointer(currentPath / s"azureFile")
  def hostPath :  io.k8s.api.core.v1.HostPathVolumeSourcePointer = io.k8s.api.core.v1.HostPathVolumeSourcePointer(currentPath / s"hostPath")
  def rbd :  io.k8s.api.core.v1.RBDVolumeSourcePointer = io.k8s.api.core.v1.RBDVolumeSourcePointer(currentPath / s"rbd")
  def configMap :  io.k8s.api.core.v1.ConfigMapVolumeSourcePointer = io.k8s.api.core.v1.ConfigMapVolumeSourcePointer(currentPath / s"configMap")
  def portworxVolume :  io.k8s.api.core.v1.PortworxVolumeSourcePointer = io.k8s.api.core.v1.PortworxVolumeSourcePointer(currentPath / s"portworxVolume")
  def glusterfs :  io.k8s.api.core.v1.GlusterfsVolumeSourcePointer = io.k8s.api.core.v1.GlusterfsVolumeSourcePointer(currentPath / s"glusterfs")
  def flocker :  io.k8s.api.core.v1.FlockerVolumeSourcePointer = io.k8s.api.core.v1.FlockerVolumeSourcePointer(currentPath / s"flocker")
  def fc :  io.k8s.api.core.v1.FCVolumeSourcePointer = io.k8s.api.core.v1.FCVolumeSourcePointer(currentPath / s"fc")
  def photonPersistentDisk :  io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer = io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer(currentPath / s"photonPersistentDisk")
  def gcePersistentDisk :  io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer = io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer(currentPath / s"gcePersistentDisk")
  def persistentVolumeClaim :  io.k8s.api.core.v1.PersistentVolumeClaimVolumeSourcePointer = io.k8s.api.core.v1.PersistentVolumeClaimVolumeSourcePointer(currentPath / s"persistentVolumeClaim")
  def vsphereVolume :  io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer = io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer(currentPath / s"vsphereVolume")
  def projected :  io.k8s.api.core.v1.ProjectedVolumeSourcePointer = io.k8s.api.core.v1.ProjectedVolumeSourcePointer(currentPath / s"projected")
  def ephemeral :  io.k8s.api.core.v1.EphemeralVolumeSourcePointer = io.k8s.api.core.v1.EphemeralVolumeSourcePointer(currentPath / s"ephemeral")
  def iscsi :  io.k8s.api.core.v1.ISCSIVolumeSourcePointer = io.k8s.api.core.v1.ISCSIVolumeSourcePointer(currentPath / s"iscsi")
  def cinder :  io.k8s.api.core.v1.CinderVolumeSourcePointer = io.k8s.api.core.v1.CinderVolumeSourcePointer(currentPath / s"cinder")
  def gitRepo :  io.k8s.api.core.v1.GitRepoVolumeSourcePointer = io.k8s.api.core.v1.GitRepoVolumeSourcePointer(currentPath / s"gitRepo")
  def cephfs :  io.k8s.api.core.v1.CephFSVolumeSourcePointer = io.k8s.api.core.v1.CephFSVolumeSourcePointer(currentPath / s"cephfs")
  def awsElasticBlockStore :  io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer = io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer(currentPath / s"awsElasticBlockStore")
  def downwardAPI :  io.k8s.api.core.v1.DownwardAPIVolumeSourcePointer = io.k8s.api.core.v1.DownwardAPIVolumeSourcePointer(currentPath / s"downwardAPI")
  def flexVolume :  io.k8s.api.core.v1.FlexVolumeSourcePointer = io.k8s.api.core.v1.FlexVolumeSourcePointer(currentPath / s"flexVolume")
  def emptyDir :  io.k8s.api.core.v1.EmptyDirVolumeSourcePointer = io.k8s.api.core.v1.EmptyDirVolumeSourcePointer(currentPath / s"emptyDir")
  def nfs :  io.k8s.api.core.v1.NFSVolumeSourcePointer = io.k8s.api.core.v1.NFSVolumeSourcePointer(currentPath / s"nfs")
  def quobyte :  io.k8s.api.core.v1.QuobyteVolumeSourcePointer = io.k8s.api.core.v1.QuobyteVolumeSourcePointer(currentPath / s"quobyte")
  def storageos :  io.k8s.api.core.v1.StorageOSVolumeSourcePointer = io.k8s.api.core.v1.StorageOSVolumeSourcePointer(currentPath / s"storageos")
}


