package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.client._

/** Pointer for APIGroup */
final case class APIGroupPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def versions : ListPointer[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] = ListPointer(currentPath / s"versions")
  def preferredVersion :  io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscoveryPointer = io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscoveryPointer(currentPath / s"preferredVersion")
  def serverAddressByClientCIDRs : ListPointer[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] = ListPointer(currentPath / s"serverAddressByClientCIDRs")
}


