package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.client._

/** Pointer for DeleteOptions */
final case class DeleteOptionsPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] {
  def orphanDependents : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"orphanDependents")
  def preconditions :  io.k8s.apimachinery.pkg.apis.meta.v1.PreconditionsPointer = io.k8s.apimachinery.pkg.apis.meta.v1.PreconditionsPointer(currentPath / s"preconditions")
  def propagationPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"propagationPolicy")
  def gracePeriodSeconds : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"gracePeriodSeconds")
  def dryRun : ListPointer[String] = ListPointer(currentPath / s"dryRun")
}


