package dev.hnaderi.k8s

import utils._

private[k8s] object ResourceCodecs {
  
  private def groupDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("APIGroup", "v1") => Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup].apply(t)
    case ("APIGroupList", "v1") => Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList].apply(t)
    case ("APIResourceList", "v1") => Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList].apply(t)
    case ("APIVersions", "v1") => Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions].apply(t)
    case ("Binding", "v1") => Decoder[io.k8s.api.core.v1.Binding].apply(t)
    case ("ComponentStatus", "v1") => Decoder[io.k8s.api.core.v1.ComponentStatus].apply(t)
    case ("ComponentStatusList", "v1") => Decoder[io.k8s.api.core.v1.ComponentStatusList].apply(t)
    case ("ConfigMap", "v1") => Decoder[io.k8s.api.core.v1.ConfigMap].apply(t)
    case ("ConfigMapList", "v1") => Decoder[io.k8s.api.core.v1.ConfigMapList].apply(t)
    case ("Endpoints", "v1") => Decoder[io.k8s.api.core.v1.Endpoints].apply(t)
    case ("EndpointsList", "v1") => Decoder[io.k8s.api.core.v1.EndpointsList].apply(t)
    case ("Event", "v1") => Decoder[io.k8s.api.core.v1.Event].apply(t)
    case ("EventList", "v1") => Decoder[io.k8s.api.core.v1.EventList].apply(t)
    case ("LimitRange", "v1") => Decoder[io.k8s.api.core.v1.LimitRange].apply(t)
    case ("LimitRangeList", "v1") => Decoder[io.k8s.api.core.v1.LimitRangeList].apply(t)
    case ("Namespace", "v1") => Decoder[io.k8s.api.core.v1.Namespace].apply(t)
    case ("NamespaceList", "v1") => Decoder[io.k8s.api.core.v1.NamespaceList].apply(t)
    case ("Node", "v1") => Decoder[io.k8s.api.core.v1.Node].apply(t)
    case ("NodeList", "v1") => Decoder[io.k8s.api.core.v1.NodeList].apply(t)
    case ("PersistentVolume", "v1") => Decoder[io.k8s.api.core.v1.PersistentVolume].apply(t)
    case ("PersistentVolumeClaim", "v1") => Decoder[io.k8s.api.core.v1.PersistentVolumeClaim].apply(t)
    case ("PersistentVolumeClaimList", "v1") => Decoder[io.k8s.api.core.v1.PersistentVolumeClaimList].apply(t)
    case ("PersistentVolumeList", "v1") => Decoder[io.k8s.api.core.v1.PersistentVolumeList].apply(t)
    case ("Pod", "v1") => Decoder[io.k8s.api.core.v1.Pod].apply(t)
    case ("PodList", "v1") => Decoder[io.k8s.api.core.v1.PodList].apply(t)
    case ("PodTemplate", "v1") => Decoder[io.k8s.api.core.v1.PodTemplate].apply(t)
    case ("PodTemplateList", "v1") => Decoder[io.k8s.api.core.v1.PodTemplateList].apply(t)
    case ("ReplicationController", "v1") => Decoder[io.k8s.api.core.v1.ReplicationController].apply(t)
    case ("ReplicationControllerList", "v1") => Decoder[io.k8s.api.core.v1.ReplicationControllerList].apply(t)
    case ("ResourceQuota", "v1") => Decoder[io.k8s.api.core.v1.ResourceQuota].apply(t)
    case ("ResourceQuotaList", "v1") => Decoder[io.k8s.api.core.v1.ResourceQuotaList].apply(t)
    case ("Secret", "v1") => Decoder[io.k8s.api.core.v1.Secret].apply(t)
    case ("SecretList", "v1") => Decoder[io.k8s.api.core.v1.SecretList].apply(t)
    case ("Service", "v1") => Decoder[io.k8s.api.core.v1.Service].apply(t)
    case ("ServiceAccount", "v1") => Decoder[io.k8s.api.core.v1.ServiceAccount].apply(t)
    case ("ServiceAccountList", "v1") => Decoder[io.k8s.api.core.v1.ServiceAccountList].apply(t)
    case ("ServiceList", "v1") => Decoder[io.k8s.api.core.v1.ServiceList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: , kind: $kind, version: $version")
  }

  private def groupauthorization_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("LocalSubjectAccessReview", "v1") => Decoder[io.k8s.api.authorization.v1.LocalSubjectAccessReview].apply(t)
    case ("SelfSubjectAccessReview", "v1") => Decoder[io.k8s.api.authorization.v1.SelfSubjectAccessReview].apply(t)
    case ("SelfSubjectRulesReview", "v1") => Decoder[io.k8s.api.authorization.v1.SelfSubjectRulesReview].apply(t)
    case ("SubjectAccessReview", "v1") => Decoder[io.k8s.api.authorization.v1.SubjectAccessReview].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: authorization.k8s.io, kind: $kind, version: $version")
  }

  private def groupevents_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("Event", "v1") => Decoder[io.k8s.api.events.v1.Event].apply(t)
    case ("EventList", "v1") => Decoder[io.k8s.api.events.v1.EventList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: events.k8s.io, kind: $kind, version: $version")
  }

  private def groupapiextensions_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("CustomResourceDefinition", "v1") => Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition].apply(t)
    case ("CustomResourceDefinitionList", "v1") => Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: apiextensions.k8s.io, kind: $kind, version: $version")
  }

  private def groupcertificates_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("CertificateSigningRequest", "v1") => Decoder[io.k8s.api.certificates.v1.CertificateSigningRequest].apply(t)
    case ("CertificateSigningRequestList", "v1") => Decoder[io.k8s.api.certificates.v1.CertificateSigningRequestList].apply(t)
    case ("ClusterTrustBundle", "v1alpha1") => Decoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle].apply(t)
    case ("ClusterTrustBundleList", "v1alpha1") => Decoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: certificates.k8s.io, kind: $kind, version: $version")
  }

  private def groupadmissionregistration_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("MutatingWebhookConfiguration", "v1") => Decoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration].apply(t)
    case ("MutatingWebhookConfigurationList", "v1") => Decoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList].apply(t)
    case ("ValidatingAdmissionPolicy", "v1") => Decoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicy].apply(t)
    case ("ValidatingAdmissionPolicy", "v1alpha1") => Decoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy].apply(t)
    case ("ValidatingAdmissionPolicy", "v1beta1") => Decoder[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicy].apply(t)
    case ("ValidatingAdmissionPolicyBinding", "v1") => Decoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBinding].apply(t)
    case ("ValidatingAdmissionPolicyBinding", "v1alpha1") => Decoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding].apply(t)
    case ("ValidatingAdmissionPolicyBinding", "v1beta1") => Decoder[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBinding].apply(t)
    case ("ValidatingAdmissionPolicyBindingList", "v1") => Decoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingList].apply(t)
    case ("ValidatingAdmissionPolicyBindingList", "v1alpha1") => Decoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingList].apply(t)
    case ("ValidatingAdmissionPolicyBindingList", "v1beta1") => Decoder[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBindingList].apply(t)
    case ("ValidatingAdmissionPolicyList", "v1") => Decoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyList].apply(t)
    case ("ValidatingAdmissionPolicyList", "v1alpha1") => Decoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyList].apply(t)
    case ("ValidatingAdmissionPolicyList", "v1beta1") => Decoder[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyList].apply(t)
    case ("ValidatingWebhookConfiguration", "v1") => Decoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration].apply(t)
    case ("ValidatingWebhookConfigurationList", "v1") => Decoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: admissionregistration.k8s.io, kind: $kind, version: $version")
  }

  private def groupauthentication_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("SelfSubjectReview", "v1") => Decoder[io.k8s.api.authentication.v1.SelfSubjectReview].apply(t)
    case ("SelfSubjectReview", "v1alpha1") => Decoder[io.k8s.api.authentication.v1alpha1.SelfSubjectReview].apply(t)
    case ("SelfSubjectReview", "v1beta1") => Decoder[io.k8s.api.authentication.v1beta1.SelfSubjectReview].apply(t)
    case ("TokenRequest", "v1") => Decoder[io.k8s.api.authentication.v1.TokenRequest].apply(t)
    case ("TokenReview", "v1") => Decoder[io.k8s.api.authentication.v1.TokenReview].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: authentication.k8s.io, kind: $kind, version: $version")
  }

  private def groupinternal_apiserver_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("StorageVersion", "v1alpha1") => Decoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion].apply(t)
    case ("StorageVersionList", "v1alpha1") => Decoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: internal.apiserver.k8s.io, kind: $kind, version: $version")
  }

  private def groupdiscovery_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("EndpointSlice", "v1") => Decoder[io.k8s.api.discovery.v1.EndpointSlice].apply(t)
    case ("EndpointSliceList", "v1") => Decoder[io.k8s.api.discovery.v1.EndpointSliceList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: discovery.k8s.io, kind: $kind, version: $version")
  }

  private def groupautoscalingDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("HorizontalPodAutoscaler", "v1") => Decoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler].apply(t)
    case ("HorizontalPodAutoscaler", "v2") => Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler].apply(t)
    case ("HorizontalPodAutoscalerList", "v1") => Decoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList].apply(t)
    case ("HorizontalPodAutoscalerList", "v2") => Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList].apply(t)
    case ("Scale", "v1") => Decoder[io.k8s.api.autoscaling.v1.Scale].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: autoscaling, kind: $kind, version: $version")
  }

  private def groupstoragemigration_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("StorageVersionMigration", "v1alpha1") => Decoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration].apply(t)
    case ("StorageVersionMigrationList", "v1alpha1") => Decoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: storagemigration.k8s.io, kind: $kind, version: $version")
  }

  private def grouprbac_authorization_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("ClusterRole", "v1") => Decoder[io.k8s.api.rbac.v1.ClusterRole].apply(t)
    case ("ClusterRoleBinding", "v1") => Decoder[io.k8s.api.rbac.v1.ClusterRoleBinding].apply(t)
    case ("ClusterRoleBindingList", "v1") => Decoder[io.k8s.api.rbac.v1.ClusterRoleBindingList].apply(t)
    case ("ClusterRoleList", "v1") => Decoder[io.k8s.api.rbac.v1.ClusterRoleList].apply(t)
    case ("Role", "v1") => Decoder[io.k8s.api.rbac.v1.Role].apply(t)
    case ("RoleBinding", "v1") => Decoder[io.k8s.api.rbac.v1.RoleBinding].apply(t)
    case ("RoleBindingList", "v1") => Decoder[io.k8s.api.rbac.v1.RoleBindingList].apply(t)
    case ("RoleList", "v1") => Decoder[io.k8s.api.rbac.v1.RoleList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: rbac.authorization.k8s.io, kind: $kind, version: $version")
  }

  private def groupcoordination_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("Lease", "v1") => Decoder[io.k8s.api.coordination.v1.Lease].apply(t)
    case ("LeaseList", "v1") => Decoder[io.k8s.api.coordination.v1.LeaseList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: coordination.k8s.io, kind: $kind, version: $version")
  }

  private def groupbatchDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("CronJob", "v1") => Decoder[io.k8s.api.batch.v1.CronJob].apply(t)
    case ("CronJobList", "v1") => Decoder[io.k8s.api.batch.v1.CronJobList].apply(t)
    case ("Job", "v1") => Decoder[io.k8s.api.batch.v1.Job].apply(t)
    case ("JobList", "v1") => Decoder[io.k8s.api.batch.v1.JobList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: batch, kind: $kind, version: $version")
  }

  private def groupnode_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("RuntimeClass", "v1") => Decoder[io.k8s.api.node.v1.RuntimeClass].apply(t)
    case ("RuntimeClassList", "v1") => Decoder[io.k8s.api.node.v1.RuntimeClassList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: node.k8s.io, kind: $kind, version: $version")
  }

  private def groupnetworking_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("IPAddress", "v1alpha1") => Decoder[io.k8s.api.networking.v1alpha1.IPAddress].apply(t)
    case ("IPAddressList", "v1alpha1") => Decoder[io.k8s.api.networking.v1alpha1.IPAddressList].apply(t)
    case ("Ingress", "v1") => Decoder[io.k8s.api.networking.v1.Ingress].apply(t)
    case ("IngressClass", "v1") => Decoder[io.k8s.api.networking.v1.IngressClass].apply(t)
    case ("IngressClassList", "v1") => Decoder[io.k8s.api.networking.v1.IngressClassList].apply(t)
    case ("IngressList", "v1") => Decoder[io.k8s.api.networking.v1.IngressList].apply(t)
    case ("NetworkPolicy", "v1") => Decoder[io.k8s.api.networking.v1.NetworkPolicy].apply(t)
    case ("NetworkPolicyList", "v1") => Decoder[io.k8s.api.networking.v1.NetworkPolicyList].apply(t)
    case ("ServiceCIDR", "v1alpha1") => Decoder[io.k8s.api.networking.v1alpha1.ServiceCIDR].apply(t)
    case ("ServiceCIDRList", "v1alpha1") => Decoder[io.k8s.api.networking.v1alpha1.ServiceCIDRList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: networking.k8s.io, kind: $kind, version: $version")
  }

  private def groupresource_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("PodSchedulingContext", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.PodSchedulingContext].apply(t)
    case ("PodSchedulingContextList", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.PodSchedulingContextList].apply(t)
    case ("ResourceClaim", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClaim].apply(t)
    case ("ResourceClaimList", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClaimList].apply(t)
    case ("ResourceClaimParameters", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClaimParameters].apply(t)
    case ("ResourceClaimParametersList", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClaimParametersList].apply(t)
    case ("ResourceClaimTemplate", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClaimTemplate].apply(t)
    case ("ResourceClaimTemplateList", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClaimTemplateList].apply(t)
    case ("ResourceClass", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClass].apply(t)
    case ("ResourceClassList", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClassList].apply(t)
    case ("ResourceClassParameters", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClassParameters].apply(t)
    case ("ResourceClassParametersList", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceClassParametersList].apply(t)
    case ("ResourceSlice", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceSlice].apply(t)
    case ("ResourceSliceList", "v1alpha2") => Decoder[io.k8s.api.resource.v1alpha2.ResourceSliceList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: resource.k8s.io, kind: $kind, version: $version")
  }

  private def groupflowcontrol_apiserver_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("FlowSchema", "v1") => Decoder[io.k8s.api.flowcontrol.v1.FlowSchema].apply(t)
    case ("FlowSchema", "v1beta3") => Decoder[io.k8s.api.flowcontrol.v1beta3.FlowSchema].apply(t)
    case ("FlowSchemaList", "v1") => Decoder[io.k8s.api.flowcontrol.v1.FlowSchemaList].apply(t)
    case ("FlowSchemaList", "v1beta3") => Decoder[io.k8s.api.flowcontrol.v1beta3.FlowSchemaList].apply(t)
    case ("PriorityLevelConfiguration", "v1") => Decoder[io.k8s.api.flowcontrol.v1.PriorityLevelConfiguration].apply(t)
    case ("PriorityLevelConfiguration", "v1beta3") => Decoder[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfiguration].apply(t)
    case ("PriorityLevelConfigurationList", "v1") => Decoder[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationList].apply(t)
    case ("PriorityLevelConfigurationList", "v1beta3") => Decoder[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: flowcontrol.apiserver.k8s.io, kind: $kind, version: $version")
  }

  private def grouppolicyDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("Eviction", "v1") => Decoder[io.k8s.api.policy.v1.Eviction].apply(t)
    case ("PodDisruptionBudget", "v1") => Decoder[io.k8s.api.policy.v1.PodDisruptionBudget].apply(t)
    case ("PodDisruptionBudgetList", "v1") => Decoder[io.k8s.api.policy.v1.PodDisruptionBudgetList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: policy, kind: $kind, version: $version")
  }

  private def groupscheduling_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("PriorityClass", "v1") => Decoder[io.k8s.api.scheduling.v1.PriorityClass].apply(t)
    case ("PriorityClassList", "v1") => Decoder[io.k8s.api.scheduling.v1.PriorityClassList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: scheduling.k8s.io, kind: $kind, version: $version")
  }

  private def groupstorage_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("CSIDriver", "v1") => Decoder[io.k8s.api.storage.v1.CSIDriver].apply(t)
    case ("CSIDriverList", "v1") => Decoder[io.k8s.api.storage.v1.CSIDriverList].apply(t)
    case ("CSINode", "v1") => Decoder[io.k8s.api.storage.v1.CSINode].apply(t)
    case ("CSINodeList", "v1") => Decoder[io.k8s.api.storage.v1.CSINodeList].apply(t)
    case ("CSIStorageCapacity", "v1") => Decoder[io.k8s.api.storage.v1.CSIStorageCapacity].apply(t)
    case ("CSIStorageCapacityList", "v1") => Decoder[io.k8s.api.storage.v1.CSIStorageCapacityList].apply(t)
    case ("StorageClass", "v1") => Decoder[io.k8s.api.storage.v1.StorageClass].apply(t)
    case ("StorageClassList", "v1") => Decoder[io.k8s.api.storage.v1.StorageClassList].apply(t)
    case ("VolumeAttachment", "v1") => Decoder[io.k8s.api.storage.v1.VolumeAttachment].apply(t)
    case ("VolumeAttachmentList", "v1") => Decoder[io.k8s.api.storage.v1.VolumeAttachmentList].apply(t)
    case ("VolumeAttributesClass", "v1alpha1") => Decoder[io.k8s.api.storage.v1alpha1.VolumeAttributesClass].apply(t)
    case ("VolumeAttributesClassList", "v1alpha1") => Decoder[io.k8s.api.storage.v1alpha1.VolumeAttributesClassList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: storage.k8s.io, kind: $kind, version: $version")
  }

  private def groupappsDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("ControllerRevision", "v1") => Decoder[io.k8s.api.apps.v1.ControllerRevision].apply(t)
    case ("ControllerRevisionList", "v1") => Decoder[io.k8s.api.apps.v1.ControllerRevisionList].apply(t)
    case ("DaemonSet", "v1") => Decoder[io.k8s.api.apps.v1.DaemonSet].apply(t)
    case ("DaemonSetList", "v1") => Decoder[io.k8s.api.apps.v1.DaemonSetList].apply(t)
    case ("Deployment", "v1") => Decoder[io.k8s.api.apps.v1.Deployment].apply(t)
    case ("DeploymentList", "v1") => Decoder[io.k8s.api.apps.v1.DeploymentList].apply(t)
    case ("ReplicaSet", "v1") => Decoder[io.k8s.api.apps.v1.ReplicaSet].apply(t)
    case ("ReplicaSetList", "v1") => Decoder[io.k8s.api.apps.v1.ReplicaSetList].apply(t)
    case ("StatefulSet", "v1") => Decoder[io.k8s.api.apps.v1.StatefulSet].apply(t)
    case ("StatefulSetList", "v1") => Decoder[io.k8s.api.apps.v1.StatefulSetList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: apps, kind: $kind, version: $version")
  }

  private def groupapiregistration_k8s_ioDecoder[T : Reader](t: T) : (String, String) => Either[String, KObject]  = {
    case ("APIService", "v1") => Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService].apply(t)
    case ("APIServiceList", "v1") => Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList].apply(t)
    case (kind, version) => Left(s"Unknown kubernetes object: group: apiregistration.k8s.io, kind: $kind, version: $version")
  }
  implicit val resourceDecoder : Decoder[KObject] = new Decoder[KObject]{
    def apply[T : Reader](t: T): Either[String, KObject] = for {
      obj <- ObjectReader(t)
      kind <- obj.read[String]("kind")
      apiVersion <- obj.read[String]("apiVersion")
      (group, secondPart) = apiVersion.splitAt(apiVersion.indexOf("/"))
      version = if(secondPart.startsWith("/")) secondPart.tail else secondPart
      res <- group match {
        case "" => groupDecoder(t).apply(kind, version)
        case "admissionregistration.k8s.io" => groupadmissionregistration_k8s_ioDecoder(t).apply(kind, version)
        case "apiextensions.k8s.io" => groupapiextensions_k8s_ioDecoder(t).apply(kind, version)
        case "apiregistration.k8s.io" => groupapiregistration_k8s_ioDecoder(t).apply(kind, version)
        case "apps" => groupappsDecoder(t).apply(kind, version)
        case "authentication.k8s.io" => groupauthentication_k8s_ioDecoder(t).apply(kind, version)
        case "authorization.k8s.io" => groupauthorization_k8s_ioDecoder(t).apply(kind, version)
        case "autoscaling" => groupautoscalingDecoder(t).apply(kind, version)
        case "batch" => groupbatchDecoder(t).apply(kind, version)
        case "certificates.k8s.io" => groupcertificates_k8s_ioDecoder(t).apply(kind, version)
        case "coordination.k8s.io" => groupcoordination_k8s_ioDecoder(t).apply(kind, version)
        case "discovery.k8s.io" => groupdiscovery_k8s_ioDecoder(t).apply(kind, version)
        case "events.k8s.io" => groupevents_k8s_ioDecoder(t).apply(kind, version)
        case "flowcontrol.apiserver.k8s.io" => groupflowcontrol_apiserver_k8s_ioDecoder(t).apply(kind, version)
        case "internal.apiserver.k8s.io" => groupinternal_apiserver_k8s_ioDecoder(t).apply(kind, version)
        case "networking.k8s.io" => groupnetworking_k8s_ioDecoder(t).apply(kind, version)
        case "node.k8s.io" => groupnode_k8s_ioDecoder(t).apply(kind, version)
        case "policy" => grouppolicyDecoder(t).apply(kind, version)
        case "rbac.authorization.k8s.io" => grouprbac_authorization_k8s_ioDecoder(t).apply(kind, version)
        case "resource.k8s.io" => groupresource_k8s_ioDecoder(t).apply(kind, version)
        case "scheduling.k8s.io" => groupscheduling_k8s_ioDecoder(t).apply(kind, version)
        case "storage.k8s.io" => groupstorage_k8s_ioDecoder(t).apply(kind, version)
        case "storagemigration.k8s.io" => groupstoragemigration_k8s_ioDecoder(t).apply(kind, version)
        case unknown => Left(s"Unknown kubernetes group id: $unknown")
      }
    } yield res
  }

}
