package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.utils._

/** ExpressionWarning is a warning information that targets a specific expression. */
final case class ExpressionWarning(
  fieldRef : String,
  warning : String
) {

  /** Returns a new data with fieldRef set to new value */
  def withFieldRef(value: String) : ExpressionWarning = copy(fieldRef = value)
  /** transforms fieldRef to result of function */
  def mapFieldRef(f: String => String) : ExpressionWarning = copy(fieldRef = f(fieldRef))

  /** Returns a new data with warning set to new value */
  def withWarning(value: String) : ExpressionWarning = copy(warning = value)
  /** transforms warning to result of function */
  def mapWarning(f: String => String) : ExpressionWarning = copy(warning = f(warning))
}

object ExpressionWarning {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.ExpressionWarning] = new Encoder[io.k8s.api.admissionregistration.v1.ExpressionWarning] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.ExpressionWarning) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("fieldRef", o.fieldRef)
            .write("warning", o.warning)
            .build
        }
    }

    implicit val decoder: Decoder[ExpressionWarning] = new Decoder[ExpressionWarning] {
      def apply[T : Reader](t: T): Either[String, ExpressionWarning] = for {
          obj <- ObjectReader(t)
          fieldRef <- obj.read[String]("fieldRef")
          warning <- obj.read[String]("warning")
      } yield ExpressionWarning (
          fieldRef = fieldRef,
          warning = warning
        )
    }
}

