package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding. */
final case class ValidatingAdmissionPolicyBindingSpec(
  matchResources : Option[io.k8s.api.admissionregistration.v1.MatchResources] = None,
  paramRef : Option[io.k8s.api.admissionregistration.v1.ParamRef] = None,
  policyName : Option[String] = None,
  validationActions : Option[Seq[String]] = None
) {

  /** Returns a new data with matchResources set to new value */
  def withMatchResources(value: io.k8s.api.admissionregistration.v1.MatchResources) : ValidatingAdmissionPolicyBindingSpec = copy(matchResources = Some(value))
  /** if matchResources has a value, transforms to the result of function*/
  def mapMatchResources(f: io.k8s.api.admissionregistration.v1.MatchResources => io.k8s.api.admissionregistration.v1.MatchResources) : ValidatingAdmissionPolicyBindingSpec = copy(matchResources = matchResources.map(f))

  /** Returns a new data with paramRef set to new value */
  def withParamRef(value: io.k8s.api.admissionregistration.v1.ParamRef) : ValidatingAdmissionPolicyBindingSpec = copy(paramRef = Some(value))
  /** if paramRef has a value, transforms to the result of function*/
  def mapParamRef(f: io.k8s.api.admissionregistration.v1.ParamRef => io.k8s.api.admissionregistration.v1.ParamRef) : ValidatingAdmissionPolicyBindingSpec = copy(paramRef = paramRef.map(f))

  /** Returns a new data with policyName set to new value */
  def withPolicyName(value: String) : ValidatingAdmissionPolicyBindingSpec = copy(policyName = Some(value))
  /** if policyName has a value, transforms to the result of function*/
  def mapPolicyName(f: String => String) : ValidatingAdmissionPolicyBindingSpec = copy(policyName = policyName.map(f))

  /** Returns a new data with validationActions set to new value */
  def withValidationActions(value: Seq[String]) : ValidatingAdmissionPolicyBindingSpec = copy(validationActions = Some(value))
  /** Appends new values to validationActions */
  def addValidationActions(newValues: String*) : ValidatingAdmissionPolicyBindingSpec = copy(validationActions = Some(validationActions.fold(newValues)(_ ++ newValues)))
  /** if validationActions has a value, transforms to the result of function*/
  def mapValidationActions(f: Seq[String] => Seq[String]) : ValidatingAdmissionPolicyBindingSpec = copy(validationActions = validationActions.map(f))
}

object ValidatingAdmissionPolicyBindingSpec {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec] = new Encoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("matchResources", o.matchResources)
            .write("paramRef", o.paramRef)
            .write("policyName", o.policyName)
            .write("validationActions", o.validationActions)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicyBindingSpec] = new Decoder[ValidatingAdmissionPolicyBindingSpec] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicyBindingSpec] = for {
          obj <- ObjectReader(t)
          matchResources <- obj.readOpt[io.k8s.api.admissionregistration.v1.MatchResources]("matchResources")
          paramRef <- obj.readOpt[io.k8s.api.admissionregistration.v1.ParamRef]("paramRef")
          policyName <- obj.readOpt[String]("policyName")
          validationActions <- obj.readOpt[Seq[String]]("validationActions")
      } yield ValidatingAdmissionPolicyBindingSpec (
          matchResources = matchResources,
          paramRef = paramRef,
          policyName = policyName,
          validationActions = validationActions
        )
    }
}

