package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicyList is a list of ValidatingAdmissionPolicy. */
final case class ValidatingAdmissionPolicyList(
  items : Option[Seq[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicy]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingAdmissionPolicyList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicy]) : ValidatingAdmissionPolicyList = copy(items = Some(value))
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicy*) : ValidatingAdmissionPolicyList = copy(items = Some(items.fold(newValues)(_ ++ newValues)))
  /** if items has a value, transforms to the result of function*/
  def mapItems(f: Seq[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicy] => Seq[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicy]) : ValidatingAdmissionPolicyList = copy(items = items.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ValidatingAdmissionPolicyList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ValidatingAdmissionPolicyList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ValidatingAdmissionPolicyList.encoder.apply(this)
}

object ValidatingAdmissionPolicyList {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyList] = new Encoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyList] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicyList] = new Decoder[ValidatingAdmissionPolicyList] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicyList] = for {
          obj <- ObjectReader(t)
          items <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicy]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ValidatingAdmissionPolicyList (
          items = items,
          metadata = metadata
        )
    }
}

