package io.k8s.api.admissionregistration.v1beta1

import dev.hnaderi.k8s.utils._

/** TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy */
final case class TypeChecking(
  expressionWarnings : Option[Seq[io.k8s.api.admissionregistration.v1beta1.ExpressionWarning]] = None
) {

  /** Returns a new data with expressionWarnings set to new value */
  def withExpressionWarnings(value: Seq[io.k8s.api.admissionregistration.v1beta1.ExpressionWarning]) : TypeChecking = copy(expressionWarnings = Some(value))
  /** Appends new values to expressionWarnings */
  def addExpressionWarnings(newValues: io.k8s.api.admissionregistration.v1beta1.ExpressionWarning*) : TypeChecking = copy(expressionWarnings = Some(expressionWarnings.fold(newValues)(_ ++ newValues)))
  /** if expressionWarnings has a value, transforms to the result of function*/
  def mapExpressionWarnings(f: Seq[io.k8s.api.admissionregistration.v1beta1.ExpressionWarning] => Seq[io.k8s.api.admissionregistration.v1beta1.ExpressionWarning]) : TypeChecking = copy(expressionWarnings = expressionWarnings.map(f))
}

object TypeChecking {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1beta1.TypeChecking] = new Encoder[io.k8s.api.admissionregistration.v1beta1.TypeChecking] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1beta1.TypeChecking) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("expressionWarnings", o.expressionWarnings)
            .build
        }
    }

    implicit val decoder: Decoder[TypeChecking] = new Decoder[TypeChecking] {
      def apply[T : Reader](t: T): Either[String, TypeChecking] = for {
          obj <- ObjectReader(t)
          expressionWarnings <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1beta1.ExpressionWarning]]("expressionWarnings")
      } yield TypeChecking (
          expressionWarnings = expressionWarnings
        )
    }
}

