package io.k8s.api.apiserverinternal.v1alpha1

import dev.hnaderi.k8s.utils._

/** An API server instance reports the version it can decode and the version it encodes objects to when persisting objects in the backend. */
final case class ServerStorageVersion(
  apiServerID : Option[String] = None,
  decodableVersions : Option[Seq[String]] = None,
  encodingVersion : Option[String] = None,
  servedVersions : Option[Seq[String]] = None
) {

  /** Returns a new data with apiServerID set to new value */
  def withApiServerID(value: String) : ServerStorageVersion = copy(apiServerID = Some(value))
  /** if apiServerID has a value, transforms to the result of function*/
  def mapApiServerID(f: String => String) : ServerStorageVersion = copy(apiServerID = apiServerID.map(f))

  /** Returns a new data with decodableVersions set to new value */
  def withDecodableVersions(value: Seq[String]) : ServerStorageVersion = copy(decodableVersions = Some(value))
  /** Appends new values to decodableVersions */
  def addDecodableVersions(newValues: String*) : ServerStorageVersion = copy(decodableVersions = Some(decodableVersions.fold(newValues)(_ ++ newValues)))
  /** if decodableVersions has a value, transforms to the result of function*/
  def mapDecodableVersions(f: Seq[String] => Seq[String]) : ServerStorageVersion = copy(decodableVersions = decodableVersions.map(f))

  /** Returns a new data with encodingVersion set to new value */
  def withEncodingVersion(value: String) : ServerStorageVersion = copy(encodingVersion = Some(value))
  /** if encodingVersion has a value, transforms to the result of function*/
  def mapEncodingVersion(f: String => String) : ServerStorageVersion = copy(encodingVersion = encodingVersion.map(f))

  /** Returns a new data with servedVersions set to new value */
  def withServedVersions(value: Seq[String]) : ServerStorageVersion = copy(servedVersions = Some(value))
  /** Appends new values to servedVersions */
  def addServedVersions(newValues: String*) : ServerStorageVersion = copy(servedVersions = Some(servedVersions.fold(newValues)(_ ++ newValues)))
  /** if servedVersions has a value, transforms to the result of function*/
  def mapServedVersions(f: Seq[String] => Seq[String]) : ServerStorageVersion = copy(servedVersions = servedVersions.map(f))
}

object ServerStorageVersion {

    implicit val encoder : Encoder[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion] = new Encoder[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion] {
        def apply[T : Builder](o: io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("apiServerID", o.apiServerID)
            .write("decodableVersions", o.decodableVersions)
            .write("encodingVersion", o.encodingVersion)
            .write("servedVersions", o.servedVersions)
            .build
        }
    }

    implicit val decoder: Decoder[ServerStorageVersion] = new Decoder[ServerStorageVersion] {
      def apply[T : Reader](t: T): Either[String, ServerStorageVersion] = for {
          obj <- ObjectReader(t)
          apiServerID <- obj.readOpt[String]("apiServerID")
          decodableVersions <- obj.readOpt[Seq[String]]("decodableVersions")
          encodingVersion <- obj.readOpt[String]("encodingVersion")
          servedVersions <- obj.readOpt[Seq[String]]("servedVersions")
      } yield ServerStorageVersion (
          apiServerID = apiServerID,
          decodableVersions = decodableVersions,
          encodingVersion = encodingVersion,
          servedVersions = servedVersions
        )
    }
}

