package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** DaemonSetStatus represents the current status of a daemon set. */
final case class DaemonSetStatus(
  numberMisscheduled : Int,
  currentNumberScheduled : Int,
  desiredNumberScheduled : Int,
  numberReady : Int,
  conditions : Option[Seq[io.k8s.api.apps.v1.DaemonSetCondition]] = None,
  updatedNumberScheduled : Option[Int] = None,
  collisionCount : Option[Int] = None,
  numberUnavailable : Option[Int] = None,
  observedGeneration : Option[Long] = None,
  numberAvailable : Option[Int] = None
) {

  /** Returns a new data with numberMisscheduled set to new value */
  def withNumberMisscheduled(value: Int) : DaemonSetStatus = copy(numberMisscheduled = value)
  /** transforms numberMisscheduled to result of function */
  def mapNumberMisscheduled(f: Int => Int) : DaemonSetStatus = copy(numberMisscheduled = f(numberMisscheduled))

  /** Returns a new data with currentNumberScheduled set to new value */
  def withCurrentNumberScheduled(value: Int) : DaemonSetStatus = copy(currentNumberScheduled = value)
  /** transforms currentNumberScheduled to result of function */
  def mapCurrentNumberScheduled(f: Int => Int) : DaemonSetStatus = copy(currentNumberScheduled = f(currentNumberScheduled))

  /** Returns a new data with desiredNumberScheduled set to new value */
  def withDesiredNumberScheduled(value: Int) : DaemonSetStatus = copy(desiredNumberScheduled = value)
  /** transforms desiredNumberScheduled to result of function */
  def mapDesiredNumberScheduled(f: Int => Int) : DaemonSetStatus = copy(desiredNumberScheduled = f(desiredNumberScheduled))

  /** Returns a new data with numberReady set to new value */
  def withNumberReady(value: Int) : DaemonSetStatus = copy(numberReady = value)
  /** transforms numberReady to result of function */
  def mapNumberReady(f: Int => Int) : DaemonSetStatus = copy(numberReady = f(numberReady))

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.apps.v1.DaemonSetCondition]) : DaemonSetStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.apps.v1.DaemonSetCondition*) : DaemonSetStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.apps.v1.DaemonSetCondition] => Seq[io.k8s.api.apps.v1.DaemonSetCondition]) : DaemonSetStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with updatedNumberScheduled set to new value */
  def withUpdatedNumberScheduled(value: Int) : DaemonSetStatus = copy(updatedNumberScheduled = Some(value))
  /** if updatedNumberScheduled has a value, transforms to the result of function*/
  def mapUpdatedNumberScheduled(f: Int => Int) : DaemonSetStatus = copy(updatedNumberScheduled = updatedNumberScheduled.map(f))

  /** Returns a new data with collisionCount set to new value */
  def withCollisionCount(value: Int) : DaemonSetStatus = copy(collisionCount = Some(value))
  /** if collisionCount has a value, transforms to the result of function*/
  def mapCollisionCount(f: Int => Int) : DaemonSetStatus = copy(collisionCount = collisionCount.map(f))

  /** Returns a new data with numberUnavailable set to new value */
  def withNumberUnavailable(value: Int) : DaemonSetStatus = copy(numberUnavailable = Some(value))
  /** if numberUnavailable has a value, transforms to the result of function*/
  def mapNumberUnavailable(f: Int => Int) : DaemonSetStatus = copy(numberUnavailable = numberUnavailable.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Long) : DaemonSetStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Long => Long) : DaemonSetStatus = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with numberAvailable set to new value */
  def withNumberAvailable(value: Int) : DaemonSetStatus = copy(numberAvailable = Some(value))
  /** if numberAvailable has a value, transforms to the result of function*/
  def mapNumberAvailable(f: Int => Int) : DaemonSetStatus = copy(numberAvailable = numberAvailable.map(f))
}

object DaemonSetStatus {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.DaemonSetStatus] = new Encoder[io.k8s.api.apps.v1.DaemonSetStatus] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.DaemonSetStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("numberMisscheduled", o.numberMisscheduled)
            .write("currentNumberScheduled", o.currentNumberScheduled)
            .write("desiredNumberScheduled", o.desiredNumberScheduled)
            .write("numberReady", o.numberReady)
            .write("conditions", o.conditions)
            .write("updatedNumberScheduled", o.updatedNumberScheduled)
            .write("collisionCount", o.collisionCount)
            .write("numberUnavailable", o.numberUnavailable)
            .write("observedGeneration", o.observedGeneration)
            .write("numberAvailable", o.numberAvailable)
            .build
        }
    }

    implicit val decoder: Decoder[DaemonSetStatus] = new Decoder[DaemonSetStatus] {
      def apply[T : Reader](t: T): Either[String, DaemonSetStatus] = for {
          obj <- ObjectReader(t)
          numberMisscheduled <- obj.read[Int]("numberMisscheduled")
          currentNumberScheduled <- obj.read[Int]("currentNumberScheduled")
          desiredNumberScheduled <- obj.read[Int]("desiredNumberScheduled")
          numberReady <- obj.read[Int]("numberReady")
          conditions <- obj.readOpt[Seq[io.k8s.api.apps.v1.DaemonSetCondition]]("conditions")
          updatedNumberScheduled <- obj.readOpt[Int]("updatedNumberScheduled")
          collisionCount <- obj.readOpt[Int]("collisionCount")
          numberUnavailable <- obj.readOpt[Int]("numberUnavailable")
          observedGeneration <- obj.readOpt[Long]("observedGeneration")
          numberAvailable <- obj.readOpt[Int]("numberAvailable")
      } yield DaemonSetStatus (
          numberMisscheduled = numberMisscheduled,
          currentNumberScheduled = currentNumberScheduled,
          desiredNumberScheduled = desiredNumberScheduled,
          numberReady = numberReady,
          conditions = conditions,
          updatedNumberScheduled = updatedNumberScheduled,
          collisionCount = collisionCount,
          numberUnavailable = numberUnavailable,
          observedGeneration = observedGeneration,
          numberAvailable = numberAvailable
        )
    }
}

