package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet. */
final case class StatefulSetOrdinals(
  start : Option[Int] = None
) {

  /** Returns a new data with start set to new value */
  def withStart(value: Int) : StatefulSetOrdinals = copy(start = Some(value))
  /** if start has a value, transforms to the result of function*/
  def mapStart(f: Int => Int) : StatefulSetOrdinals = copy(start = start.map(f))
}

object StatefulSetOrdinals {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.StatefulSetOrdinals] = new Encoder[io.k8s.api.apps.v1.StatefulSetOrdinals] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.StatefulSetOrdinals) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("start", o.start)
            .build
        }
    }

    implicit val decoder: Decoder[StatefulSetOrdinals] = new Decoder[StatefulSetOrdinals] {
      def apply[T : Reader](t: T): Either[String, StatefulSetOrdinals] = for {
          obj <- ObjectReader(t)
          start <- obj.readOpt[Int]("start")
      } yield StatefulSetOrdinals (
          start = start
        )
    }
}

