package io.k8s.api.certificates.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).

ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the `clusterTrustBundle` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.

It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle. */
final case class ClusterTrustBundle(
  spec : io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("certificates.k8s.io", "ClusterTrustBundle", "v1alpha1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec) : ClusterTrustBundle = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec => io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec) : ClusterTrustBundle = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterTrustBundle = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterTrustBundle = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ClusterTrustBundle.encoder.apply(this)
}

object ClusterTrustBundle {

    implicit val encoder : Encoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle] = new Encoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle] {
        def apply[T : Builder](o: io.k8s.api.certificates.v1alpha1.ClusterTrustBundle) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ClusterTrustBundle] = new Decoder[ClusterTrustBundle] {
      def apply[T : Reader](t: T): Either[String, ClusterTrustBundle] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ClusterTrustBundle (
          spec = spec,
          metadata = metadata
        )
    }
}

