package io.k8s.api.certificates.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ClusterTrustBundleList is a collection of ClusterTrustBundle objects */
final case class ClusterTrustBundleList(
  items : Seq[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("certificates.k8s.io", "ClusterTrustBundleList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle]) : ClusterTrustBundleList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.certificates.v1alpha1.ClusterTrustBundle*) : ClusterTrustBundleList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle] => Seq[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle]) : ClusterTrustBundleList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterTrustBundleList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterTrustBundleList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ClusterTrustBundleList.encoder.apply(this)
}

object ClusterTrustBundleList {

    implicit val encoder : Encoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList] = new Encoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList] {
        def apply[T : Builder](o: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ClusterTrustBundleList] = new Decoder[ClusterTrustBundleList] {
      def apply[T : Reader](t: T): Either[String, ClusterTrustBundleList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ClusterTrustBundleList (
          items = items,
          metadata = metadata
        )
    }
}

