package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ContainerResizePolicy represents resource resize policy for the container. */
final case class ContainerResizePolicy(
  resourceName : String,
  restartPolicy : String
) {

  /** Returns a new data with resourceName set to new value */
  def withResourceName(value: String) : ContainerResizePolicy = copy(resourceName = value)
  /** transforms resourceName to result of function */
  def mapResourceName(f: String => String) : ContainerResizePolicy = copy(resourceName = f(resourceName))

  /** Returns a new data with restartPolicy set to new value */
  def withRestartPolicy(value: String) : ContainerResizePolicy = copy(restartPolicy = value)
  /** transforms restartPolicy to result of function */
  def mapRestartPolicy(f: String => String) : ContainerResizePolicy = copy(restartPolicy = f(restartPolicy))
}

object ContainerResizePolicy {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ContainerResizePolicy] = new Encoder[io.k8s.api.core.v1.ContainerResizePolicy] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ContainerResizePolicy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resourceName", o.resourceName)
            .write("restartPolicy", o.restartPolicy)
            .build
        }
    }

    implicit val decoder: Decoder[ContainerResizePolicy] = new Decoder[ContainerResizePolicy] {
      def apply[T : Reader](t: T): Either[String, ContainerResizePolicy] = for {
          obj <- ObjectReader(t)
          resourceName <- obj.read[String]("resourceName")
          restartPolicy <- obj.read[String]("restartPolicy")
      } yield ContainerResizePolicy (
          resourceName = resourceName,
          restartPolicy = restartPolicy
        )
    }
}

