package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ContainerStateWaiting is a waiting state of a container. */
final case class ContainerStateWaiting(
  message : Option[String] = None,
  reason : Option[String] = None
) {

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ContainerStateWaiting = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ContainerStateWaiting = copy(message = message.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : ContainerStateWaiting = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : ContainerStateWaiting = copy(reason = reason.map(f))
}

object ContainerStateWaiting {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ContainerStateWaiting] = new Encoder[io.k8s.api.core.v1.ContainerStateWaiting] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ContainerStateWaiting) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("message", o.message)
            .write("reason", o.reason)
            .build
        }
    }

    implicit val decoder: Decoder[ContainerStateWaiting] = new Decoder[ContainerStateWaiting] {
      def apply[T : Reader](t: T): Either[String, ContainerStateWaiting] = for {
          obj <- ObjectReader(t)
          message <- obj.readOpt[String]("message")
          reason <- obj.readOpt[String]("reason")
      } yield ContainerStateWaiting (
          message = message,
          reason = reason
        )
    }
}

