package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode. */
final case class DownwardAPIProjection(
  items : Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
) {

  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIProjection = copy(items = Some(value))
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.DownwardAPIVolumeFile*) : DownwardAPIProjection = copy(items = Some(items.fold(newValues)(_ ++ newValues)))
  /** if items has a value, transforms to the result of function*/
  def mapItems(f: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile] => Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIProjection = copy(items = items.map(f))
}

object DownwardAPIProjection {

    implicit val encoder : Encoder[io.k8s.api.core.v1.DownwardAPIProjection] = new Encoder[io.k8s.api.core.v1.DownwardAPIProjection] {
        def apply[T : Builder](o: io.k8s.api.core.v1.DownwardAPIProjection) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .build
        }
    }

    implicit val decoder: Decoder[DownwardAPIProjection] = new Decoder[DownwardAPIProjection] {
      def apply[T : Reader](t: T): Either[String, DownwardAPIProjection] = for {
          obj <- ObjectReader(t)
          items <- obj.readOpt[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]]("items")
      } yield DownwardAPIProjection (
          items = items
        )
    }
}

