package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data. */
final case class Event(
  involvedObject : io.k8s.api.core.v1.ObjectReference,
  metadata : io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta,
  series : Option[io.k8s.api.core.v1.EventSeries] = None,
  count : Option[Int] = None,
  source : Option[io.k8s.api.core.v1.EventSource] = None,
  reportingComponent : Option[String] = None,
  reason : Option[String] = None,
  related : Option[io.k8s.api.core.v1.ObjectReference] = None,
  eventTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  lastTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  firstTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  `type` : Option[String] = None,
  reportingInstance : Option[String] = None,
  action : Option[String] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Event", "v1")


  /** Returns a new data with involvedObject set to new value */
  def withInvolvedObject(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(involvedObject = value)
  /** transforms involvedObject to result of function */
  def mapInvolvedObject(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : Event = copy(involvedObject = f(involvedObject))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Event = copy(metadata = value)
  /** transforms metadata to result of function */
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Event = copy(metadata = f(metadata))

  /** Returns a new data with series set to new value */
  def withSeries(value: io.k8s.api.core.v1.EventSeries) : Event = copy(series = Some(value))
  /** if series has a value, transforms to the result of function*/
  def mapSeries(f: io.k8s.api.core.v1.EventSeries => io.k8s.api.core.v1.EventSeries) : Event = copy(series = series.map(f))

  /** Returns a new data with count set to new value */
  def withCount(value: Int) : Event = copy(count = Some(value))
  /** if count has a value, transforms to the result of function*/
  def mapCount(f: Int => Int) : Event = copy(count = count.map(f))

  /** Returns a new data with source set to new value */
  def withSource(value: io.k8s.api.core.v1.EventSource) : Event = copy(source = Some(value))
  /** if source has a value, transforms to the result of function*/
  def mapSource(f: io.k8s.api.core.v1.EventSource => io.k8s.api.core.v1.EventSource) : Event = copy(source = source.map(f))

  /** Returns a new data with reportingComponent set to new value */
  def withReportingComponent(value: String) : Event = copy(reportingComponent = Some(value))
  /** if reportingComponent has a value, transforms to the result of function*/
  def mapReportingComponent(f: String => String) : Event = copy(reportingComponent = reportingComponent.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : Event = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : Event = copy(reason = reason.map(f))

  /** Returns a new data with related set to new value */
  def withRelated(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(related = Some(value))
  /** if related has a value, transforms to the result of function*/
  def mapRelated(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : Event = copy(related = related.map(f))

  /** Returns a new data with eventTime set to new value */
  def withEventTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : Event = copy(eventTime = Some(value))
  /** if eventTime has a value, transforms to the result of function*/
  def mapEventTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : Event = copy(eventTime = eventTime.map(f))

  /** Returns a new data with lastTimestamp set to new value */
  def withLastTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(lastTimestamp = Some(value))
  /** if lastTimestamp has a value, transforms to the result of function*/
  def mapLastTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(lastTimestamp = lastTimestamp.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : Event = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : Event = copy(message = message.map(f))

  /** Returns a new data with firstTimestamp set to new value */
  def withFirstTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(firstTimestamp = Some(value))
  /** if firstTimestamp has a value, transforms to the result of function*/
  def mapFirstTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(firstTimestamp = firstTimestamp.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : Event = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : Event = copy(`type` = `type`.map(f))

  /** Returns a new data with reportingInstance set to new value */
  def withReportingInstance(value: String) : Event = copy(reportingInstance = Some(value))
  /** if reportingInstance has a value, transforms to the result of function*/
  def mapReportingInstance(f: String => String) : Event = copy(reportingInstance = reportingInstance.map(f))

  /** Returns a new data with action set to new value */
  def withAction(value: String) : Event = copy(action = Some(value))
  /** if action has a value, transforms to the result of function*/
  def mapAction(f: String => String) : Event = copy(action = action.map(f))

  override def foldTo[T : Builder] : T = Event.encoder.apply(this)
}

object Event {

    implicit val encoder : Encoder[io.k8s.api.core.v1.Event] = new Encoder[io.k8s.api.core.v1.Event] {
        def apply[T : Builder](o: io.k8s.api.core.v1.Event) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("involvedObject", o.involvedObject)
            .write("metadata", o.metadata)
            .write("series", o.series)
            .write("count", o.count)
            .write("source", o.source)
            .write("reportingComponent", o.reportingComponent)
            .write("reason", o.reason)
            .write("related", o.related)
            .write("eventTime", o.eventTime)
            .write("lastTimestamp", o.lastTimestamp)
            .write("message", o.message)
            .write("firstTimestamp", o.firstTimestamp)
            .write("type", o.`type`)
            .write("reportingInstance", o.reportingInstance)
            .write("action", o.action)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Event] = new Decoder[Event] {
      def apply[T : Reader](t: T): Either[String, Event] = for {
          obj <- ObjectReader(t)
          involvedObject <- obj.read[io.k8s.api.core.v1.ObjectReference]("involvedObject")
          metadata <- obj.read[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          series <- obj.readOpt[io.k8s.api.core.v1.EventSeries]("series")
          count <- obj.readOpt[Int]("count")
          source <- obj.readOpt[io.k8s.api.core.v1.EventSource]("source")
          reportingComponent <- obj.readOpt[String]("reportingComponent")
          reason <- obj.readOpt[String]("reason")
          related <- obj.readOpt[io.k8s.api.core.v1.ObjectReference]("related")
          eventTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("eventTime")
          lastTimestamp <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTimestamp")
          message <- obj.readOpt[String]("message")
          firstTimestamp <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("firstTimestamp")
          `type` <- obj.readOpt[String]("type")
          reportingInstance <- obj.readOpt[String]("reportingInstance")
          action <- obj.readOpt[String]("action")
      } yield Event (
          involvedObject = involvedObject,
          metadata = metadata,
          series = series,
          count = count,
          source = source,
          reportingComponent = reportingComponent,
          reason = reason,
          related = related,
          eventTime = eventTime,
          lastTimestamp = lastTimestamp,
          message = message,
          firstTimestamp = firstTimestamp,
          `type` = `type`,
          reportingInstance = reportingInstance,
          action = action
        )
    }
}

